/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionScalingConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<GetFunctionScalingConfigResponse.Builder, GetFunctionScalingConfigResponse> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(GetFunctionScalingConfigResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<FunctionScalingConfig> APPLIED_FUNCTION_SCALING_CONFIG_FIELD = SdkField
            .<FunctionScalingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AppliedFunctionScalingConfig")
            .getter(getter(GetFunctionScalingConfigResponse::appliedFunctionScalingConfig))
            .setter(setter(Builder::appliedFunctionScalingConfig))
            .constructor(FunctionScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedFunctionScalingConfig")
                    .build()).build();

    private static final SdkField<FunctionScalingConfig> REQUESTED_FUNCTION_SCALING_CONFIG_FIELD = SdkField
            .<FunctionScalingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("RequestedFunctionScalingConfig")
            .getter(getter(GetFunctionScalingConfigResponse::requestedFunctionScalingConfig))
            .setter(setter(Builder::requestedFunctionScalingConfig))
            .constructor(FunctionScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedFunctionScalingConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            APPLIED_FUNCTION_SCALING_CONFIG_FIELD, REQUESTED_FUNCTION_SCALING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String functionArn;

    private final FunctionScalingConfig appliedFunctionScalingConfig;

    private final FunctionScalingConfig requestedFunctionScalingConfig;

    private GetFunctionScalingConfigResponse(BuilderImpl builder) {
        super(builder);
        this.functionArn = builder.functionArn;
        this.appliedFunctionScalingConfig = builder.appliedFunctionScalingConfig;
        this.requestedFunctionScalingConfig = builder.requestedFunctionScalingConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The scaling configuration that is currently applied to the function. This represents the actual scaling settings
     * in effect.
     * </p>
     * 
     * @return The scaling configuration that is currently applied to the function. This represents the actual scaling
     *         settings in effect.
     */
    public final FunctionScalingConfig appliedFunctionScalingConfig() {
        return appliedFunctionScalingConfig;
    }

    /**
     * <p>
     * The scaling configuration that was requested for the function.
     * </p>
     * 
     * @return The scaling configuration that was requested for the function.
     */
    public final FunctionScalingConfig requestedFunctionScalingConfig() {
        return requestedFunctionScalingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(appliedFunctionScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(requestedFunctionScalingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionScalingConfigResponse)) {
            return false;
        }
        GetFunctionScalingConfigResponse other = (GetFunctionScalingConfigResponse) obj;
        return Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(appliedFunctionScalingConfig(), other.appliedFunctionScalingConfig())
                && Objects.equals(requestedFunctionScalingConfig(), other.requestedFunctionScalingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionScalingConfigResponse").add("FunctionArn", functionArn())
                .add("AppliedFunctionScalingConfig", appliedFunctionScalingConfig())
                .add("RequestedFunctionScalingConfig", requestedFunctionScalingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "AppliedFunctionScalingConfig":
            return Optional.ofNullable(clazz.cast(appliedFunctionScalingConfig()));
        case "RequestedFunctionScalingConfig":
            return Optional.ofNullable(clazz.cast(requestedFunctionScalingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("AppliedFunctionScalingConfig", APPLIED_FUNCTION_SCALING_CONFIG_FIELD);
        map.put("RequestedFunctionScalingConfig", REQUESTED_FUNCTION_SCALING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionScalingConfigResponse, T> g) {
        return obj -> g.apply((GetFunctionScalingConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionScalingConfigResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The scaling configuration that is currently applied to the function. This represents the actual scaling
         * settings in effect.
         * </p>
         * 
         * @param appliedFunctionScalingConfig
         *        The scaling configuration that is currently applied to the function. This represents the actual
         *        scaling settings in effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedFunctionScalingConfig(FunctionScalingConfig appliedFunctionScalingConfig);

        /**
         * <p>
         * The scaling configuration that is currently applied to the function. This represents the actual scaling
         * settings in effect.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionScalingConfig.Builder} avoiding
         * the need to create one manually via {@link FunctionScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #appliedFunctionScalingConfig(FunctionScalingConfig)}.
         * 
         * @param appliedFunctionScalingConfig
         *        a consumer that will call methods on {@link FunctionScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appliedFunctionScalingConfig(FunctionScalingConfig)
         */
        default Builder appliedFunctionScalingConfig(Consumer<FunctionScalingConfig.Builder> appliedFunctionScalingConfig) {
            return appliedFunctionScalingConfig(FunctionScalingConfig.builder().applyMutation(appliedFunctionScalingConfig)
                    .build());
        }

        /**
         * <p>
         * The scaling configuration that was requested for the function.
         * </p>
         * 
         * @param requestedFunctionScalingConfig
         *        The scaling configuration that was requested for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedFunctionScalingConfig(FunctionScalingConfig requestedFunctionScalingConfig);

        /**
         * <p>
         * The scaling configuration that was requested for the function.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionScalingConfig.Builder} avoiding
         * the need to create one manually via {@link FunctionScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #requestedFunctionScalingConfig(FunctionScalingConfig)}.
         * 
         * @param requestedFunctionScalingConfig
         *        a consumer that will call methods on {@link FunctionScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedFunctionScalingConfig(FunctionScalingConfig)
         */
        default Builder requestedFunctionScalingConfig(Consumer<FunctionScalingConfig.Builder> requestedFunctionScalingConfig) {
            return requestedFunctionScalingConfig(FunctionScalingConfig.builder().applyMutation(requestedFunctionScalingConfig)
                    .build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String functionArn;

        private FunctionScalingConfig appliedFunctionScalingConfig;

        private FunctionScalingConfig requestedFunctionScalingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionScalingConfigResponse model) {
            super(model);
            functionArn(model.functionArn);
            appliedFunctionScalingConfig(model.appliedFunctionScalingConfig);
            requestedFunctionScalingConfig(model.requestedFunctionScalingConfig);
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final FunctionScalingConfig.Builder getAppliedFunctionScalingConfig() {
            return appliedFunctionScalingConfig != null ? appliedFunctionScalingConfig.toBuilder() : null;
        }

        public final void setAppliedFunctionScalingConfig(FunctionScalingConfig.BuilderImpl appliedFunctionScalingConfig) {
            this.appliedFunctionScalingConfig = appliedFunctionScalingConfig != null ? appliedFunctionScalingConfig.build()
                    : null;
        }

        @Override
        public final Builder appliedFunctionScalingConfig(FunctionScalingConfig appliedFunctionScalingConfig) {
            this.appliedFunctionScalingConfig = appliedFunctionScalingConfig;
            return this;
        }

        public final FunctionScalingConfig.Builder getRequestedFunctionScalingConfig() {
            return requestedFunctionScalingConfig != null ? requestedFunctionScalingConfig.toBuilder() : null;
        }

        public final void setRequestedFunctionScalingConfig(FunctionScalingConfig.BuilderImpl requestedFunctionScalingConfig) {
            this.requestedFunctionScalingConfig = requestedFunctionScalingConfig != null ? requestedFunctionScalingConfig.build()
                    : null;
        }

        @Override
        public final Builder requestedFunctionScalingConfig(FunctionScalingConfig requestedFunctionScalingConfig) {
            this.requestedFunctionScalingConfig = requestedFunctionScalingConfig;
            return this;
        }

        @Override
        public GetFunctionScalingConfigResponse build() {
            return new GetFunctionScalingConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
