/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDurableExecutionStateRequest extends LambdaRequest implements
        ToCopyableBuilder<GetDurableExecutionStateRequest.Builder, GetDurableExecutionStateRequest> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(GetDurableExecutionStateRequest::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DurableExecutionArn").build()).build();

    private static final SdkField<String> CHECKPOINT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckpointToken").getter(getter(GetDurableExecutionStateRequest::checkpointToken))
            .setter(setter(Builder::checkpointToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CheckpointToken").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(GetDurableExecutionStateRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(GetDurableExecutionStateRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD,
            CHECKPOINT_TOKEN_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String durableExecutionArn;

    private final String checkpointToken;

    private final String marker;

    private final Integer maxItems;

    private GetDurableExecutionStateRequest(BuilderImpl builder) {
        super(builder);
        this.durableExecutionArn = builder.durableExecutionArn;
        this.checkpointToken = builder.checkpointToken;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    /**
     * <p>
     * A checkpoint token that identifies the current state of the execution. This token is provided by the Lambda
     * runtime and ensures that state retrieval is consistent with the current execution context.
     * </p>
     * 
     * @return A checkpoint token that identifies the current state of the execution. This token is provided by the
     *         Lambda runtime and ensures that state retrieval is consistent with the current execution context.
     */
    public final String checkpointToken() {
        return checkpointToken;
    }

    /**
     * <p>
     * If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next page of
     * operations. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next page
     *         of operations. Each pagination token expires after 24 hours.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of operations to return per call. You can use <code>Marker</code> to retrieve additional pages
     * of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the default.
     * </p>
     * 
     * @return The maximum number of operations to return per call. You can use <code>Marker</code> to retrieve
     *         additional pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the
     *         default.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointToken());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDurableExecutionStateRequest)) {
            return false;
        }
        GetDurableExecutionStateRequest other = (GetDurableExecutionStateRequest) obj;
        return Objects.equals(durableExecutionArn(), other.durableExecutionArn())
                && Objects.equals(checkpointToken(), other.checkpointToken()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDurableExecutionStateRequest").add("DurableExecutionArn", durableExecutionArn())
                .add("CheckpointToken", checkpointToken()).add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        case "CheckpointToken":
            return Optional.ofNullable(clazz.cast(checkpointToken()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("CheckpointToken", CHECKPOINT_TOKEN_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDurableExecutionStateRequest, T> g) {
        return obj -> g.apply((GetDurableExecutionStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDurableExecutionStateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) of the durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);

        /**
         * <p>
         * A checkpoint token that identifies the current state of the execution. This token is provided by the Lambda
         * runtime and ensures that state retrieval is consistent with the current execution context.
         * </p>
         * 
         * @param checkpointToken
         *        A checkpoint token that identifies the current state of the execution. This token is provided by the
         *        Lambda runtime and ensures that state retrieval is consistent with the current execution context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointToken(String checkpointToken);

        /**
         * <p>
         * If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next page of
         * operations. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param marker
         *        If <code>NextMarker</code> was returned from a previous request, use this value to retrieve the next
         *        page of operations. Each pagination token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of operations to return per call. You can use <code>Marker</code> to retrieve additional
         * pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the default.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of operations to return per call. You can use <code>Marker</code> to retrieve
         *        additional pages of results. The default is 100 and the maximum allowed is 1000. A value of 0 uses the
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String durableExecutionArn;

        private String checkpointToken;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDurableExecutionStateRequest model) {
            super(model);
            durableExecutionArn(model.durableExecutionArn);
            checkpointToken(model.checkpointToken);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getCheckpointToken() {
            return checkpointToken;
        }

        public final void setCheckpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
        }

        @Override
        public final Builder checkpointToken(String checkpointToken) {
            this.checkpointToken = checkpointToken;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDurableExecutionStateRequest build() {
            return new GetDurableExecutionStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
