/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A capacity provider manages compute resources for Lambda functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityProvider.Builder, CapacityProvider> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityProviderArn").getter(getter(CapacityProvider::capacityProviderArn))
            .setter(setter(Builder::capacityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderArn").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CapacityProvider::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<CapacityProviderVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<CapacityProviderVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(CapacityProvider::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(CapacityProviderVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<CapacityProviderPermissionsConfig> PERMISSIONS_CONFIG_FIELD = SdkField
            .<CapacityProviderPermissionsConfig> builder(MarshallingType.SDK_POJO).memberName("PermissionsConfig")
            .getter(getter(CapacityProvider::permissionsConfig)).setter(setter(Builder::permissionsConfig))
            .constructor(CapacityProviderPermissionsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsConfig").build()).build();

    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirements> builder(MarshallingType.SDK_POJO).memberName("InstanceRequirements")
            .getter(getter(CapacityProvider::instanceRequirements)).setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build())
            .build();

    private static final SdkField<CapacityProviderScalingConfig> CAPACITY_PROVIDER_SCALING_CONFIG_FIELD = SdkField
            .<CapacityProviderScalingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityProviderScalingConfig")
            .getter(getter(CapacityProvider::capacityProviderScalingConfig))
            .setter(setter(Builder::capacityProviderScalingConfig))
            .constructor(CapacityProviderScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderScalingConfig")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CapacityProvider::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModified").getter(getter(CapacityProvider::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD,
            STATE_FIELD, VPC_CONFIG_FIELD, PERMISSIONS_CONFIG_FIELD, INSTANCE_REQUIREMENTS_FIELD,
            CAPACITY_PROVIDER_SCALING_CONFIG_FIELD, KMS_KEY_ARN_FIELD, LAST_MODIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityProviderArn;

    private final String state;

    private final CapacityProviderVpcConfig vpcConfig;

    private final CapacityProviderPermissionsConfig permissionsConfig;

    private final InstanceRequirements instanceRequirements;

    private final CapacityProviderScalingConfig capacityProviderScalingConfig;

    private final String kmsKeyArn;

    private final String lastModified;

    private CapacityProvider(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.permissionsConfig = builder.permissionsConfig;
        this.instanceRequirements = builder.instanceRequirements;
        this.capacityProviderScalingConfig = builder.capacityProviderScalingConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the capacity provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the capacity provider.
     */
    public final String capacityProviderArn() {
        return capacityProviderArn;
    }

    /**
     * <p>
     * The current state of the capacity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityProviderState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the capacity provider.
     * @see CapacityProviderState
     */
    public final CapacityProviderState state() {
        return CapacityProviderState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the capacity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityProviderState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the capacity provider.
     * @see CapacityProviderState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The VPC configuration for the capacity provider.
     * </p>
     * 
     * @return The VPC configuration for the capacity provider.
     */
    public final CapacityProviderVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The permissions configuration for the capacity provider.
     * </p>
     * 
     * @return The permissions configuration for the capacity provider.
     */
    public final CapacityProviderPermissionsConfig permissionsConfig() {
        return permissionsConfig;
    }

    /**
     * <p>
     * The instance requirements for compute resources managed by the capacity provider.
     * </p>
     * 
     * @return The instance requirements for compute resources managed by the capacity provider.
     */
    public final InstanceRequirements instanceRequirements() {
        return instanceRequirements;
    }

    /**
     * <p>
     * The scaling configuration for the capacity provider.
     * </p>
     * 
     * @return The scaling configuration for the capacity provider.
     */
    public final CapacityProviderScalingConfig capacityProviderScalingConfig() {
        return capacityProviderScalingConfig;
    }

    /**
     * <p>
     * The ARN of the KMS key used to encrypt the capacity provider's resources.
     * </p>
     * 
     * @return The ARN of the KMS key used to encrypt the capacity provider's resources.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The date and time when the capacity provider was last modified.
     * </p>
     * 
     * @return The date and time when the capacity provider was last modified.
     */
    public final String lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProvider)) {
            return false;
        }
        CapacityProvider other = (CapacityProvider) obj;
        return Objects.equals(capacityProviderArn(), other.capacityProviderArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(permissionsConfig(), other.permissionsConfig())
                && Objects.equals(instanceRequirements(), other.instanceRequirements())
                && Objects.equals(capacityProviderScalingConfig(), other.capacityProviderScalingConfig())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityProvider").add("CapacityProviderArn", capacityProviderArn())
                .add("State", stateAsString()).add("VpcConfig", vpcConfig()).add("PermissionsConfig", permissionsConfig())
                .add("InstanceRequirements", instanceRequirements())
                .add("CapacityProviderScalingConfig", capacityProviderScalingConfig()).add("KmsKeyArn", kmsKeyArn())
                .add("LastModified", lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderArn":
            return Optional.ofNullable(clazz.cast(capacityProviderArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "PermissionsConfig":
            return Optional.ofNullable(clazz.cast(permissionsConfig()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        case "CapacityProviderScalingConfig":
            return Optional.ofNullable(clazz.cast(capacityProviderScalingConfig()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("PermissionsConfig", PERMISSIONS_CONFIG_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("CapacityProviderScalingConfig", CAPACITY_PROVIDER_SCALING_CONFIG_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityProvider, T> g) {
        return obj -> g.apply((CapacityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityProvider> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the capacity provider.
         * </p>
         * 
         * @param capacityProviderArn
         *        The Amazon Resource Name (ARN) of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderArn(String capacityProviderArn);

        /**
         * <p>
         * The current state of the capacity provider.
         * </p>
         * 
         * @param state
         *        The current state of the capacity provider.
         * @see CapacityProviderState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the capacity provider.
         * </p>
         * 
         * @param state
         *        The current state of the capacity provider.
         * @see CapacityProviderState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityProviderState
         */
        Builder state(CapacityProviderState state);

        /**
         * <p>
         * The VPC configuration for the capacity provider.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(CapacityProviderVpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityProviderVpcConfig.Builder}
         * avoiding the need to create one manually via {@link CapacityProviderVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityProviderVpcConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfig(CapacityProviderVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link CapacityProviderVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(CapacityProviderVpcConfig)
         */
        default Builder vpcConfig(Consumer<CapacityProviderVpcConfig.Builder> vpcConfig) {
            return vpcConfig(CapacityProviderVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The permissions configuration for the capacity provider.
         * </p>
         * 
         * @param permissionsConfig
         *        The permissions configuration for the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsConfig(CapacityProviderPermissionsConfig permissionsConfig);

        /**
         * <p>
         * The permissions configuration for the capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CapacityProviderPermissionsConfig.Builder} avoiding the need to create one manually via
         * {@link CapacityProviderPermissionsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityProviderPermissionsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionsConfig(CapacityProviderPermissionsConfig)}.
         * 
         * @param permissionsConfig
         *        a consumer that will call methods on {@link CapacityProviderPermissionsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsConfig(CapacityProviderPermissionsConfig)
         */
        default Builder permissionsConfig(Consumer<CapacityProviderPermissionsConfig.Builder> permissionsConfig) {
            return permissionsConfig(CapacityProviderPermissionsConfig.builder().applyMutation(permissionsConfig).build());
        }

        /**
         * <p>
         * The instance requirements for compute resources managed by the capacity provider.
         * </p>
         * 
         * @param instanceRequirements
         *        The instance requirements for compute resources managed by the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirements instanceRequirements);

        /**
         * <p>
         * The instance requirements for compute resources managed by the capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRequirements.Builder} avoiding
         * the need to create one manually via {@link InstanceRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRequirements.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceRequirements(InstanceRequirements)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirements)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirements.builder().applyMutation(instanceRequirements).build());
        }

        /**
         * <p>
         * The scaling configuration for the capacity provider.
         * </p>
         * 
         * @param capacityProviderScalingConfig
         *        The scaling configuration for the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig);

        /**
         * <p>
         * The scaling configuration for the capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityProviderScalingConfig.Builder}
         * avoiding the need to create one manually via {@link CapacityProviderScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityProviderScalingConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderScalingConfig(CapacityProviderScalingConfig)}.
         * 
         * @param capacityProviderScalingConfig
         *        a consumer that will call methods on {@link CapacityProviderScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderScalingConfig(CapacityProviderScalingConfig)
         */
        default Builder capacityProviderScalingConfig(
                Consumer<CapacityProviderScalingConfig.Builder> capacityProviderScalingConfig) {
            return capacityProviderScalingConfig(CapacityProviderScalingConfig.builder()
                    .applyMutation(capacityProviderScalingConfig).build());
        }

        /**
         * <p>
         * The ARN of the KMS key used to encrypt the capacity provider's resources.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key used to encrypt the capacity provider's resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The date and time when the capacity provider was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time when the capacity provider was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);
    }

    static final class BuilderImpl implements Builder {
        private String capacityProviderArn;

        private String state;

        private CapacityProviderVpcConfig vpcConfig;

        private CapacityProviderPermissionsConfig permissionsConfig;

        private InstanceRequirements instanceRequirements;

        private CapacityProviderScalingConfig capacityProviderScalingConfig;

        private String kmsKeyArn;

        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProvider model) {
            capacityProviderArn(model.capacityProviderArn);
            state(model.state);
            vpcConfig(model.vpcConfig);
            permissionsConfig(model.permissionsConfig);
            instanceRequirements(model.instanceRequirements);
            capacityProviderScalingConfig(model.capacityProviderScalingConfig);
            kmsKeyArn(model.kmsKeyArn);
            lastModified(model.lastModified);
        }

        public final String getCapacityProviderArn() {
            return capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityProviderState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final CapacityProviderVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(CapacityProviderVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(CapacityProviderVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final CapacityProviderPermissionsConfig.Builder getPermissionsConfig() {
            return permissionsConfig != null ? permissionsConfig.toBuilder() : null;
        }

        public final void setPermissionsConfig(CapacityProviderPermissionsConfig.BuilderImpl permissionsConfig) {
            this.permissionsConfig = permissionsConfig != null ? permissionsConfig.build() : null;
        }

        @Override
        public final Builder permissionsConfig(CapacityProviderPermissionsConfig permissionsConfig) {
            this.permissionsConfig = permissionsConfig;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final CapacityProviderScalingConfig.Builder getCapacityProviderScalingConfig() {
            return capacityProviderScalingConfig != null ? capacityProviderScalingConfig.toBuilder() : null;
        }

        public final void setCapacityProviderScalingConfig(CapacityProviderScalingConfig.BuilderImpl capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig != null ? capacityProviderScalingConfig.build()
                    : null;
        }

        @Override
        public final Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getLastModified() {
            return lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public CapacityProvider build() {
            return new CapacityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
