/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventResult> {
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Payload").getter(EventResult.getter(EventResult::payload)).setter(EventResult.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Truncated").getter(EventResult.getter(EventResult::truncated)).setter(EventResult.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FIELD, TRUNCATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String payload;
    private final Boolean truncated;

    private EventResult(BuilderImpl builder) {
        this.payload = builder.payload;
        this.truncated = builder.truncated;
    }

    public final String payload() {
        return this.payload;
    }

    public final Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventResult)) {
            return false;
        }
        EventResult other = (EventResult)obj;
        return Objects.equals(this.payload(), other.payload()) && Objects.equals(this.truncated(), other.truncated());
    }

    public final String toString() {
        return ToString.builder((String)"EventResult").add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).add("Truncated", (Object)this.truncated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Payload", PAYLOAD_FIELD);
        map.put("Truncated", TRUNCATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventResult, T> g) {
        return obj -> g.apply((EventResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String payload;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(EventResult model) {
            this.payload(model.payload);
            this.truncated(model.truncated);
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public EventResult build() {
            return new EventResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventResult> {
        public Builder payload(String var1);

        public Builder truncated(Boolean var1);
    }
}

