/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedPollerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedPollerConfig> {
    private static final SdkField<Integer> MINIMUM_POLLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumPollers").getter(ProvisionedPollerConfig.getter(ProvisionedPollerConfig::minimumPollers)).setter(ProvisionedPollerConfig.setter(Builder::minimumPollers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumPollers").build()}).build();
    private static final SdkField<Integer> MAXIMUM_POLLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPollers").getter(ProvisionedPollerConfig.getter(ProvisionedPollerConfig::maximumPollers)).setter(ProvisionedPollerConfig.setter(Builder::maximumPollers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPollers").build()}).build();
    private static final SdkField<String> POLLER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PollerGroupName").getter(ProvisionedPollerConfig.getter(ProvisionedPollerConfig::pollerGroupName)).setter(ProvisionedPollerConfig.setter(Builder::pollerGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PollerGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_POLLERS_FIELD, MAXIMUM_POLLERS_FIELD, POLLER_GROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisionedPollerConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer minimumPollers;
    private final Integer maximumPollers;
    private final String pollerGroupName;

    private ProvisionedPollerConfig(BuilderImpl builder) {
        this.minimumPollers = builder.minimumPollers;
        this.maximumPollers = builder.maximumPollers;
        this.pollerGroupName = builder.pollerGroupName;
    }

    public final Integer minimumPollers() {
        return this.minimumPollers;
    }

    public final Integer maximumPollers() {
        return this.maximumPollers;
    }

    public final String pollerGroupName() {
        return this.pollerGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumPollers());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPollers());
        hashCode = 31 * hashCode + Objects.hashCode(this.pollerGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedPollerConfig)) {
            return false;
        }
        ProvisionedPollerConfig other = (ProvisionedPollerConfig)obj;
        return Objects.equals(this.minimumPollers(), other.minimumPollers()) && Objects.equals(this.maximumPollers(), other.maximumPollers()) && Objects.equals(this.pollerGroupName(), other.pollerGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedPollerConfig").add("MinimumPollers", (Object)this.minimumPollers()).add("MaximumPollers", (Object)this.maximumPollers()).add("PollerGroupName", (Object)this.pollerGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumPollers": {
                return Optional.ofNullable(clazz.cast(this.minimumPollers()));
            }
            case "MaximumPollers": {
                return Optional.ofNullable(clazz.cast(this.maximumPollers()));
            }
            case "PollerGroupName": {
                return Optional.ofNullable(clazz.cast(this.pollerGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MinimumPollers", MINIMUM_POLLERS_FIELD);
        map.put("MaximumPollers", MAXIMUM_POLLERS_FIELD);
        map.put("PollerGroupName", POLLER_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedPollerConfig, T> g) {
        return obj -> g.apply((ProvisionedPollerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumPollers;
        private Integer maximumPollers;
        private String pollerGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedPollerConfig model) {
            this.minimumPollers(model.minimumPollers);
            this.maximumPollers(model.maximumPollers);
            this.pollerGroupName(model.pollerGroupName);
        }

        public final Integer getMinimumPollers() {
            return this.minimumPollers;
        }

        public final void setMinimumPollers(Integer minimumPollers) {
            this.minimumPollers = minimumPollers;
        }

        @Override
        public final Builder minimumPollers(Integer minimumPollers) {
            this.minimumPollers = minimumPollers;
            return this;
        }

        public final Integer getMaximumPollers() {
            return this.maximumPollers;
        }

        public final void setMaximumPollers(Integer maximumPollers) {
            this.maximumPollers = maximumPollers;
        }

        @Override
        public final Builder maximumPollers(Integer maximumPollers) {
            this.maximumPollers = maximumPollers;
            return this;
        }

        public final String getPollerGroupName() {
            return this.pollerGroupName;
        }

        public final void setPollerGroupName(String pollerGroupName) {
            this.pollerGroupName = pollerGroupName;
        }

        @Override
        public final Builder pollerGroupName(String pollerGroupName) {
            this.pollerGroupName = pollerGroupName;
            return this;
        }

        public ProvisionedPollerConfig build() {
            return new ProvisionedPollerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedPollerConfig> {
        public Builder minimumPollers(Integer var1);

        public Builder maximumPollers(Integer var1);

        public Builder pollerGroupName(String var1);
    }
}

