/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;

public class ListEventSourceMappingsPublisher
implements SdkPublisher<ListEventSourceMappingsResponse> {
    private final LambdaAsyncClient client;
    private final ListEventSourceMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventSourceMappingsPublisher(LambdaAsyncClient client, ListEventSourceMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventSourceMappingsPublisher(LambdaAsyncClient client, ListEventSourceMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventSourceMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventSourceMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventSourceMappingConfiguration> eventSourceMappings() {
        Function<ListEventSourceMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSourceMappings() != null) {
                return response.eventSourceMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventSourceMappingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventSourceMappingsResponseFetcher
    implements AsyncPageFetcher<ListEventSourceMappingsResponse> {
        private ListEventSourceMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventSourceMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListEventSourceMappingsResponse> nextPage(ListEventSourceMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListEventSourceMappingsPublisher.this.client.listEventSourceMappings(ListEventSourceMappingsPublisher.this.firstRequest);
            }
            return ListEventSourceMappingsPublisher.this.client.listEventSourceMappings((ListEventSourceMappingsRequest)((Object)ListEventSourceMappingsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

