/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.AmazonManagedKafkaEventSourceConfig;
import software.amazon.awssdk.services.lambda.model.DestinationConfig;
import software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingMetricsConfig;
import software.amazon.awssdk.services.lambda.model.EventSourcePosition;
import software.amazon.awssdk.services.lambda.model.FilterCriteria;
import software.amazon.awssdk.services.lambda.model.FilterCriteriaError;
import software.amazon.awssdk.services.lambda.model.FunctionResponseType;
import software.amazon.awssdk.services.lambda.model.FunctionResponseTypeListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.ProvisionedPollerConfig;
import software.amazon.awssdk.services.lambda.model.QueuesCopier;
import software.amazon.awssdk.services.lambda.model.ScalingConfig;
import software.amazon.awssdk.services.lambda.model.SelfManagedEventSource;
import software.amazon.awssdk.services.lambda.model.SelfManagedKafkaEventSourceConfig;
import software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration;
import software.amazon.awssdk.services.lambda.model.SourceAccessConfigurationsCopier;
import software.amazon.awssdk.services.lambda.model.TopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventSourceMappingResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetEventSourceMappingResponse> {
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UUID").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::uuid)).setter(GetEventSourceMappingResponse.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::startingPositionAsString)).setter(GetEventSourceMappingResponse.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<Instant> STARTING_POSITION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartingPositionTimestamp").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::startingPositionTimestamp)).setter(GetEventSourceMappingResponse.setter(Builder::startingPositionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPositionTimestamp").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::batchSize)).setter(GetEventSourceMappingResponse.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::maximumBatchingWindowInSeconds)).setter(GetEventSourceMappingResponse.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelizationFactor").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::parallelizationFactor)).setter(GetEventSourceMappingResponse.setter(Builder::parallelizationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::eventSourceArn)).setter(GetEventSourceMappingResponse.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::filterCriteria)).setter(GetEventSourceMappingResponse.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::functionArn)).setter(GetEventSourceMappingResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::lastModified)).setter(GetEventSourceMappingResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastProcessingResult").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::lastProcessingResult)).setter(GetEventSourceMappingResponse.setter(Builder::lastProcessingResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::state)).setter(GetEventSourceMappingResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateTransitionReason").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::stateTransitionReason)).setter(GetEventSourceMappingResponse.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::destinationConfig)).setter(GetEventSourceMappingResponse.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()}).build();
    private static final SdkField<List<String>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Topics").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::topics)).setter(GetEventSourceMappingResponse.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::queues)).setter(GetEventSourceMappingResponse.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SourceAccessConfiguration>> SOURCE_ACCESS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAccessConfigurations").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::sourceAccessConfigurations)).setter(GetEventSourceMappingResponse.setter(Builder::sourceAccessConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccessConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SelfManagedEventSource> SELF_MANAGED_EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedEventSource").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::selfManagedEventSource)).setter(GetEventSourceMappingResponse.setter(Builder::selfManagedEventSource)).constructor(SelfManagedEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedEventSource").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::maximumRecordAgeInSeconds)).setter(GetEventSourceMappingResponse.setter(Builder::maximumRecordAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build()}).build();
    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BisectBatchOnFunctionError").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::bisectBatchOnFunctionError)).setter(GetEventSourceMappingResponse.setter(Builder::bisectBatchOnFunctionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::maximumRetryAttempts)).setter(GetEventSourceMappingResponse.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<Integer> TUMBLING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TumblingWindowInSeconds").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::tumblingWindowInSeconds)).setter(GetEventSourceMappingResponse.setter(Builder::tumblingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TumblingWindowInSeconds").build()}).build();
    private static final SdkField<List<String>> FUNCTION_RESPONSE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionResponseTypes").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::functionResponseTypesAsStrings)).setter(GetEventSourceMappingResponse.setter(Builder::functionResponseTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionResponseTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AmazonManagedKafkaEventSourceConfig> AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonManagedKafkaEventSourceConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::amazonManagedKafkaEventSourceConfig)).setter(GetEventSourceMappingResponse.setter(Builder::amazonManagedKafkaEventSourceConfig)).constructor(AmazonManagedKafkaEventSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonManagedKafkaEventSourceConfig").build()}).build();
    private static final SdkField<SelfManagedKafkaEventSourceConfig> SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedKafkaEventSourceConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::selfManagedKafkaEventSourceConfig)).setter(GetEventSourceMappingResponse.setter(Builder::selfManagedKafkaEventSourceConfig)).constructor(SelfManagedKafkaEventSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaEventSourceConfig").build()}).build();
    private static final SdkField<ScalingConfig> SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::scalingConfig)).setter(GetEventSourceMappingResponse.setter(Builder::scalingConfig)).constructor(ScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfig").build()}).build();
    private static final SdkField<DocumentDBEventSourceConfig> DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentDBEventSourceConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::documentDBEventSourceConfig)).setter(GetEventSourceMappingResponse.setter(Builder::documentDBEventSourceConfig)).constructor(DocumentDBEventSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDBEventSourceConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyArn").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::kmsKeyArn)).setter(GetEventSourceMappingResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()}).build();
    private static final SdkField<FilterCriteriaError> FILTER_CRITERIA_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteriaError").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::filterCriteriaError)).setter(GetEventSourceMappingResponse.setter(Builder::filterCriteriaError)).constructor(FilterCriteriaError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteriaError").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_MAPPING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceMappingArn").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::eventSourceMappingArn)).setter(GetEventSourceMappingResponse.setter(Builder::eventSourceMappingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceMappingArn").build()}).build();
    private static final SdkField<EventSourceMappingMetricsConfig> METRICS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricsConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::metricsConfig)).setter(GetEventSourceMappingResponse.setter(Builder::metricsConfig)).constructor(EventSourceMappingMetricsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsConfig").build()}).build();
    private static final SdkField<ProvisionedPollerConfig> PROVISIONED_POLLER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedPollerConfig").getter(GetEventSourceMappingResponse.getter(GetEventSourceMappingResponse::provisionedPollerConfig)).setter(GetEventSourceMappingResponse.setter(Builder::provisionedPollerConfig)).constructor(ProvisionedPollerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedPollerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD, STARTING_POSITION_FIELD, STARTING_POSITION_TIMESTAMP_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, PARALLELIZATION_FACTOR_FIELD, EVENT_SOURCE_ARN_FIELD, FILTER_CRITERIA_FIELD, FUNCTION_ARN_FIELD, LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, DESTINATION_CONFIG_FIELD, TOPICS_FIELD, QUEUES_FIELD, SOURCE_ACCESS_CONFIGURATIONS_FIELD, SELF_MANAGED_EVENT_SOURCE_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, BISECT_BATCH_ON_FUNCTION_ERROR_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, TUMBLING_WINDOW_IN_SECONDS_FIELD, FUNCTION_RESPONSE_TYPES_FIELD, AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD, SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD, SCALING_CONFIG_FIELD, DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD, KMS_KEY_ARN_FIELD, FILTER_CRITERIA_ERROR_FIELD, EVENT_SOURCE_MAPPING_ARN_FIELD, METRICS_CONFIG_FIELD, PROVISIONED_POLLER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEventSourceMappingResponse.memberNameToFieldInitializer();
    private final String uuid;
    private final String startingPosition;
    private final Instant startingPositionTimestamp;
    private final Integer batchSize;
    private final Integer maximumBatchingWindowInSeconds;
    private final Integer parallelizationFactor;
    private final String eventSourceArn;
    private final FilterCriteria filterCriteria;
    private final String functionArn;
    private final Instant lastModified;
    private final String lastProcessingResult;
    private final String state;
    private final String stateTransitionReason;
    private final DestinationConfig destinationConfig;
    private final List<String> topics;
    private final List<String> queues;
    private final List<SourceAccessConfiguration> sourceAccessConfigurations;
    private final SelfManagedEventSource selfManagedEventSource;
    private final Integer maximumRecordAgeInSeconds;
    private final Boolean bisectBatchOnFunctionError;
    private final Integer maximumRetryAttempts;
    private final Integer tumblingWindowInSeconds;
    private final List<String> functionResponseTypes;
    private final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;
    private final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;
    private final ScalingConfig scalingConfig;
    private final DocumentDBEventSourceConfig documentDBEventSourceConfig;
    private final String kmsKeyArn;
    private final FilterCriteriaError filterCriteriaError;
    private final String eventSourceMappingArn;
    private final EventSourceMappingMetricsConfig metricsConfig;
    private final ProvisionedPollerConfig provisionedPollerConfig;

    private GetEventSourceMappingResponse(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.eventSourceArn = builder.eventSourceArn;
        this.filterCriteria = builder.filterCriteria;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.destinationConfig = builder.destinationConfig;
        this.topics = builder.topics;
        this.queues = builder.queues;
        this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
        this.selfManagedEventSource = builder.selfManagedEventSource;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        this.functionResponseTypes = builder.functionResponseTypes;
        this.amazonManagedKafkaEventSourceConfig = builder.amazonManagedKafkaEventSourceConfig;
        this.selfManagedKafkaEventSourceConfig = builder.selfManagedKafkaEventSourceConfig;
        this.scalingConfig = builder.scalingConfig;
        this.documentDBEventSourceConfig = builder.documentDBEventSourceConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.filterCriteriaError = builder.filterCriteriaError;
        this.eventSourceMappingArn = builder.eventSourceMappingArn;
        this.metricsConfig = builder.metricsConfig;
        this.provisionedPollerConfig = builder.provisionedPollerConfig;
    }

    public final String uuid() {
        return this.uuid;
    }

    public final EventSourcePosition startingPosition() {
        return EventSourcePosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final Instant startingPositionTimestamp() {
        return this.startingPositionTimestamp;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final Integer parallelizationFactor() {
        return this.parallelizationFactor;
    }

    public final String eventSourceArn() {
        return this.eventSourceArn;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String lastProcessingResult() {
        return this.lastProcessingResult;
    }

    public final String state() {
        return this.state;
    }

    public final String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public final DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<String> topics() {
        return this.topics;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<String> queues() {
        return this.queues;
    }

    public final boolean hasSourceAccessConfigurations() {
        return this.sourceAccessConfigurations != null && !(this.sourceAccessConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SourceAccessConfiguration> sourceAccessConfigurations() {
        return this.sourceAccessConfigurations;
    }

    public final SelfManagedEventSource selfManagedEventSource() {
        return this.selfManagedEventSource;
    }

    public final Integer maximumRecordAgeInSeconds() {
        return this.maximumRecordAgeInSeconds;
    }

    public final Boolean bisectBatchOnFunctionError() {
        return this.bisectBatchOnFunctionError;
    }

    public final Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public final Integer tumblingWindowInSeconds() {
        return this.tumblingWindowInSeconds;
    }

    public final List<FunctionResponseType> functionResponseTypes() {
        return FunctionResponseTypeListCopier.copyStringToEnum(this.functionResponseTypes);
    }

    public final boolean hasFunctionResponseTypes() {
        return this.functionResponseTypes != null && !(this.functionResponseTypes instanceof SdkAutoConstructList);
    }

    public final List<String> functionResponseTypesAsStrings() {
        return this.functionResponseTypes;
    }

    public final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig() {
        return this.amazonManagedKafkaEventSourceConfig;
    }

    public final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig() {
        return this.selfManagedKafkaEventSourceConfig;
    }

    public final ScalingConfig scalingConfig() {
        return this.scalingConfig;
    }

    public final DocumentDBEventSourceConfig documentDBEventSourceConfig() {
        return this.documentDBEventSourceConfig;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final FilterCriteriaError filterCriteriaError() {
        return this.filterCriteriaError;
    }

    public final String eventSourceMappingArn() {
        return this.eventSourceMappingArn;
    }

    public final EventSourceMappingMetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    public final ProvisionedPollerConfig provisionedPollerConfig() {
        return this.provisionedPollerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAccessConfigurations() ? this.sourceAccessConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.tumblingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionResponseTypes() ? this.functionResponseTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDBEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteriaError());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceMappingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedPollerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventSourceMappingResponse)) {
            return false;
        }
        GetEventSourceMappingResponse other = (GetEventSourceMappingResponse)((Object)obj);
        return Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.startingPositionTimestamp(), other.startingPositionTimestamp()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.parallelizationFactor(), other.parallelizationFactor()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics()) && this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && this.hasSourceAccessConfigurations() == other.hasSourceAccessConfigurations() && Objects.equals(this.sourceAccessConfigurations(), other.sourceAccessConfigurations()) && Objects.equals(this.selfManagedEventSource(), other.selfManagedEventSource()) && Objects.equals(this.maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds()) && Objects.equals(this.bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && Objects.equals(this.tumblingWindowInSeconds(), other.tumblingWindowInSeconds()) && this.hasFunctionResponseTypes() == other.hasFunctionResponseTypes() && Objects.equals(this.functionResponseTypesAsStrings(), other.functionResponseTypesAsStrings()) && Objects.equals(this.amazonManagedKafkaEventSourceConfig(), other.amazonManagedKafkaEventSourceConfig()) && Objects.equals(this.selfManagedKafkaEventSourceConfig(), other.selfManagedKafkaEventSourceConfig()) && Objects.equals(this.scalingConfig(), other.scalingConfig()) && Objects.equals(this.documentDBEventSourceConfig(), other.documentDBEventSourceConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.filterCriteriaError(), other.filterCriteriaError()) && Objects.equals(this.eventSourceMappingArn(), other.eventSourceMappingArn()) && Objects.equals(this.metricsConfig(), other.metricsConfig()) && Objects.equals(this.provisionedPollerConfig(), other.provisionedPollerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventSourceMappingResponse").add("UUID", (Object)this.uuid()).add("StartingPosition", (Object)this.startingPositionAsString()).add("StartingPositionTimestamp", (Object)this.startingPositionTimestamp()).add("BatchSize", (Object)this.batchSize()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("ParallelizationFactor", (Object)this.parallelizationFactor()).add("EventSourceArn", (Object)this.eventSourceArn()).add("FilterCriteria", (Object)this.filterCriteria()).add("FunctionArn", (Object)this.functionArn()).add("LastModified", (Object)this.lastModified()).add("LastProcessingResult", (Object)this.lastProcessingResult()).add("State", (Object)this.state()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("DestinationConfig", (Object)this.destinationConfig()).add("Topics", this.hasTopics() ? this.topics() : null).add("Queues", this.hasQueues() ? this.queues() : null).add("SourceAccessConfigurations", this.hasSourceAccessConfigurations() ? this.sourceAccessConfigurations() : null).add("SelfManagedEventSource", (Object)this.selfManagedEventSource()).add("MaximumRecordAgeInSeconds", (Object)this.maximumRecordAgeInSeconds()).add("BisectBatchOnFunctionError", (Object)this.bisectBatchOnFunctionError()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("TumblingWindowInSeconds", (Object)this.tumblingWindowInSeconds()).add("FunctionResponseTypes", this.hasFunctionResponseTypes() ? this.functionResponseTypesAsStrings() : null).add("AmazonManagedKafkaEventSourceConfig", (Object)this.amazonManagedKafkaEventSourceConfig()).add("SelfManagedKafkaEventSourceConfig", (Object)this.selfManagedKafkaEventSourceConfig()).add("ScalingConfig", (Object)this.scalingConfig()).add("DocumentDBEventSourceConfig", (Object)this.documentDBEventSourceConfig()).add("KMSKeyArn", (Object)this.kmsKeyArn()).add("FilterCriteriaError", (Object)this.filterCriteriaError()).add("EventSourceMappingArn", (Object)this.eventSourceMappingArn()).add("MetricsConfig", (Object)this.metricsConfig()).add("ProvisionedPollerConfig", (Object)this.provisionedPollerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UUID": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "StartingPositionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startingPositionTimestamp()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "ParallelizationFactor": {
                return Optional.ofNullable(clazz.cast(this.parallelizationFactor()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LastProcessingResult": {
                return Optional.ofNullable(clazz.cast(this.lastProcessingResult()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "Topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "SourceAccessConfigurations": {
                return Optional.ofNullable(clazz.cast(this.sourceAccessConfigurations()));
            }
            case "SelfManagedEventSource": {
                return Optional.ofNullable(clazz.cast(this.selfManagedEventSource()));
            }
            case "MaximumRecordAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumRecordAgeInSeconds()));
            }
            case "BisectBatchOnFunctionError": {
                return Optional.ofNullable(clazz.cast(this.bisectBatchOnFunctionError()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "TumblingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.tumblingWindowInSeconds()));
            }
            case "FunctionResponseTypes": {
                return Optional.ofNullable(clazz.cast(this.functionResponseTypesAsStrings()));
            }
            case "AmazonManagedKafkaEventSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.amazonManagedKafkaEventSourceConfig()));
            }
            case "SelfManagedKafkaEventSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.selfManagedKafkaEventSourceConfig()));
            }
            case "ScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.scalingConfig()));
            }
            case "DocumentDBEventSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.documentDBEventSourceConfig()));
            }
            case "KMSKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "FilterCriteriaError": {
                return Optional.ofNullable(clazz.cast(this.filterCriteriaError()));
            }
            case "EventSourceMappingArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceMappingArn()));
            }
            case "MetricsConfig": {
                return Optional.ofNullable(clazz.cast(this.metricsConfig()));
            }
            case "ProvisionedPollerConfig": {
                return Optional.ofNullable(clazz.cast(this.provisionedPollerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UUID", UUID_FIELD);
        map.put("StartingPosition", STARTING_POSITION_FIELD);
        map.put("StartingPositionTimestamp", STARTING_POSITION_TIMESTAMP_FIELD);
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        map.put("ParallelizationFactor", PARALLELIZATION_FACTOR_FIELD);
        map.put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
        map.put("FilterCriteria", FILTER_CRITERIA_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("LastProcessingResult", LAST_PROCESSING_RESULT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateTransitionReason", STATE_TRANSITION_REASON_FIELD);
        map.put("DestinationConfig", DESTINATION_CONFIG_FIELD);
        map.put("Topics", TOPICS_FIELD);
        map.put("Queues", QUEUES_FIELD);
        map.put("SourceAccessConfigurations", SOURCE_ACCESS_CONFIGURATIONS_FIELD);
        map.put("SelfManagedEventSource", SELF_MANAGED_EVENT_SOURCE_FIELD);
        map.put("MaximumRecordAgeInSeconds", MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD);
        map.put("BisectBatchOnFunctionError", BISECT_BATCH_ON_FUNCTION_ERROR_FIELD);
        map.put("MaximumRetryAttempts", MAXIMUM_RETRY_ATTEMPTS_FIELD);
        map.put("TumblingWindowInSeconds", TUMBLING_WINDOW_IN_SECONDS_FIELD);
        map.put("FunctionResponseTypes", FUNCTION_RESPONSE_TYPES_FIELD);
        map.put("AmazonManagedKafkaEventSourceConfig", AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD);
        map.put("SelfManagedKafkaEventSourceConfig", SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD);
        map.put("ScalingConfig", SCALING_CONFIG_FIELD);
        map.put("DocumentDBEventSourceConfig", DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD);
        map.put("KMSKeyArn", KMS_KEY_ARN_FIELD);
        map.put("FilterCriteriaError", FILTER_CRITERIA_ERROR_FIELD);
        map.put("EventSourceMappingArn", EVENT_SOURCE_MAPPING_ARN_FIELD);
        map.put("MetricsConfig", METRICS_CONFIG_FIELD);
        map.put("ProvisionedPollerConfig", PROVISIONED_POLLER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEventSourceMappingResponse, T> g) {
        return obj -> g.apply((GetEventSourceMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String uuid;
        private String startingPosition;
        private Instant startingPositionTimestamp;
        private Integer batchSize;
        private Integer maximumBatchingWindowInSeconds;
        private Integer parallelizationFactor;
        private String eventSourceArn;
        private FilterCriteria filterCriteria;
        private String functionArn;
        private Instant lastModified;
        private String lastProcessingResult;
        private String state;
        private String stateTransitionReason;
        private DestinationConfig destinationConfig;
        private List<String> topics = DefaultSdkAutoConstructList.getInstance();
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();
        private List<SourceAccessConfiguration> sourceAccessConfigurations = DefaultSdkAutoConstructList.getInstance();
        private SelfManagedEventSource selfManagedEventSource;
        private Integer maximumRecordAgeInSeconds;
        private Boolean bisectBatchOnFunctionError;
        private Integer maximumRetryAttempts;
        private Integer tumblingWindowInSeconds;
        private List<String> functionResponseTypes = DefaultSdkAutoConstructList.getInstance();
        private AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;
        private SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;
        private ScalingConfig scalingConfig;
        private DocumentDBEventSourceConfig documentDBEventSourceConfig;
        private String kmsKeyArn;
        private FilterCriteriaError filterCriteriaError;
        private String eventSourceMappingArn;
        private EventSourceMappingMetricsConfig metricsConfig;
        private ProvisionedPollerConfig provisionedPollerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventSourceMappingResponse model) {
            super(model);
            this.uuid(model.uuid);
            this.startingPosition(model.startingPosition);
            this.startingPositionTimestamp(model.startingPositionTimestamp);
            this.batchSize(model.batchSize);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.parallelizationFactor(model.parallelizationFactor);
            this.eventSourceArn(model.eventSourceArn);
            this.filterCriteria(model.filterCriteria);
            this.functionArn(model.functionArn);
            this.lastModified(model.lastModified);
            this.lastProcessingResult(model.lastProcessingResult);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.destinationConfig(model.destinationConfig);
            this.topics(model.topics);
            this.queues(model.queues);
            this.sourceAccessConfigurations(model.sourceAccessConfigurations);
            this.selfManagedEventSource(model.selfManagedEventSource);
            this.maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            this.bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.tumblingWindowInSeconds(model.tumblingWindowInSeconds);
            this.functionResponseTypesWithStrings(model.functionResponseTypes);
            this.amazonManagedKafkaEventSourceConfig(model.amazonManagedKafkaEventSourceConfig);
            this.selfManagedKafkaEventSourceConfig(model.selfManagedKafkaEventSourceConfig);
            this.scalingConfig(model.scalingConfig);
            this.documentDBEventSourceConfig(model.documentDBEventSourceConfig);
            this.kmsKeyArn(model.kmsKeyArn);
            this.filterCriteriaError(model.filterCriteriaError);
            this.eventSourceMappingArn(model.eventSourceMappingArn);
            this.metricsConfig(model.metricsConfig);
            this.provisionedPollerConfig(model.provisionedPollerConfig);
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Instant getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getLastProcessingResult() {
            return this.lastProcessingResult;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Collection<String> getTopics() {
            if (this.topics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topics;
        }

        public final void setTopics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
        }

        @Override
        public final Builder topics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(String ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        public final Collection<String> getQueues() {
            if (this.queues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final List<SourceAccessConfiguration.Builder> getSourceAccessConfigurations() {
            List<SourceAccessConfiguration.Builder> result = SourceAccessConfigurationsCopier.copyToBuilder(this.sourceAccessConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAccessConfigurations(Collection<SourceAccessConfiguration.BuilderImpl> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copyFromBuilder(sourceAccessConfigurations);
        }

        @Override
        public final Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copy(sourceAccessConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(SourceAccessConfiguration ... sourceAccessConfigurations) {
            this.sourceAccessConfigurations(Arrays.asList(sourceAccessConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder> ... sourceAccessConfigurations) {
            this.sourceAccessConfigurations(Stream.of(sourceAccessConfigurations).map(c -> (SourceAccessConfiguration)((SourceAccessConfiguration.Builder)SourceAccessConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SelfManagedEventSource.Builder getSelfManagedEventSource() {
            return this.selfManagedEventSource != null ? this.selfManagedEventSource.toBuilder() : null;
        }

        public final void setSelfManagedEventSource(SelfManagedEventSource.BuilderImpl selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource != null ? selfManagedEventSource.build() : null;
        }

        @Override
        public final Builder selfManagedEventSource(SelfManagedEventSource selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return this.bisectBatchOnFunctionError;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getTumblingWindowInSeconds() {
            return this.tumblingWindowInSeconds;
        }

        public final void setTumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
        }

        @Override
        public final Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        public final Collection<String> getFunctionResponseTypes() {
            if (this.functionResponseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functionResponseTypes;
        }

        public final void setFunctionResponseTypes(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
        }

        @Override
        public final Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypesWithStrings(String ... functionResponseTypes) {
            this.functionResponseTypesWithStrings(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        public final Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copyEnumToString(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypes(FunctionResponseType ... functionResponseTypes) {
            this.functionResponseTypes(Arrays.asList(functionResponseTypes));
            return this;
        }

        public final AmazonManagedKafkaEventSourceConfig.Builder getAmazonManagedKafkaEventSourceConfig() {
            return this.amazonManagedKafkaEventSourceConfig != null ? this.amazonManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setAmazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig.BuilderImpl amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig != null ? amazonManagedKafkaEventSourceConfig.build() : null;
        }

        @Override
        public final Builder amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        public final SelfManagedKafkaEventSourceConfig.Builder getSelfManagedKafkaEventSourceConfig() {
            return this.selfManagedKafkaEventSourceConfig != null ? this.selfManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setSelfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig.BuilderImpl selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig != null ? selfManagedKafkaEventSourceConfig.build() : null;
        }

        @Override
        public final Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        public final ScalingConfig.Builder getScalingConfig() {
            return this.scalingConfig != null ? this.scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(ScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(ScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final DocumentDBEventSourceConfig.Builder getDocumentDBEventSourceConfig() {
            return this.documentDBEventSourceConfig != null ? this.documentDBEventSourceConfig.toBuilder() : null;
        }

        public final void setDocumentDBEventSourceConfig(DocumentDBEventSourceConfig.BuilderImpl documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig != null ? documentDBEventSourceConfig.build() : null;
        }

        @Override
        public final Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final FilterCriteriaError.Builder getFilterCriteriaError() {
            return this.filterCriteriaError != null ? this.filterCriteriaError.toBuilder() : null;
        }

        public final void setFilterCriteriaError(FilterCriteriaError.BuilderImpl filterCriteriaError) {
            this.filterCriteriaError = filterCriteriaError != null ? filterCriteriaError.build() : null;
        }

        @Override
        public final Builder filterCriteriaError(FilterCriteriaError filterCriteriaError) {
            this.filterCriteriaError = filterCriteriaError;
            return this;
        }

        public final String getEventSourceMappingArn() {
            return this.eventSourceMappingArn;
        }

        public final void setEventSourceMappingArn(String eventSourceMappingArn) {
            this.eventSourceMappingArn = eventSourceMappingArn;
        }

        @Override
        public final Builder eventSourceMappingArn(String eventSourceMappingArn) {
            this.eventSourceMappingArn = eventSourceMappingArn;
            return this;
        }

        public final EventSourceMappingMetricsConfig.Builder getMetricsConfig() {
            return this.metricsConfig != null ? this.metricsConfig.toBuilder() : null;
        }

        public final void setMetricsConfig(EventSourceMappingMetricsConfig.BuilderImpl metricsConfig) {
            this.metricsConfig = metricsConfig != null ? metricsConfig.build() : null;
        }

        @Override
        public final Builder metricsConfig(EventSourceMappingMetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public final ProvisionedPollerConfig.Builder getProvisionedPollerConfig() {
            return this.provisionedPollerConfig != null ? this.provisionedPollerConfig.toBuilder() : null;
        }

        public final void setProvisionedPollerConfig(ProvisionedPollerConfig.BuilderImpl provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig != null ? provisionedPollerConfig.build() : null;
        }

        @Override
        public final Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        @Override
        public GetEventSourceMappingResponse build() {
            return new GetEventSourceMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventSourceMappingResponse> {
        public Builder uuid(String var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(EventSourcePosition var1);

        public Builder startingPositionTimestamp(Instant var1);

        public Builder batchSize(Integer var1);

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder parallelizationFactor(Integer var1);

        public Builder eventSourceArn(String var1);

        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder functionArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder lastProcessingResult(String var1);

        public Builder state(String var1);

        public Builder stateTransitionReason(String var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder topics(Collection<String> var1);

        public Builder topics(String ... var1);

        public Builder queues(Collection<String> var1);

        public Builder queues(String ... var1);

        public Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> var1);

        public Builder sourceAccessConfigurations(SourceAccessConfiguration ... var1);

        public Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder> ... var1);

        public Builder selfManagedEventSource(SelfManagedEventSource var1);

        default public Builder selfManagedEventSource(Consumer<SelfManagedEventSource.Builder> selfManagedEventSource) {
            return this.selfManagedEventSource((SelfManagedEventSource)((SelfManagedEventSource.Builder)SelfManagedEventSource.builder().applyMutation(selfManagedEventSource)).build());
        }

        public Builder maximumRecordAgeInSeconds(Integer var1);

        public Builder bisectBatchOnFunctionError(Boolean var1);

        public Builder maximumRetryAttempts(Integer var1);

        public Builder tumblingWindowInSeconds(Integer var1);

        public Builder functionResponseTypesWithStrings(Collection<String> var1);

        public Builder functionResponseTypesWithStrings(String ... var1);

        public Builder functionResponseTypes(Collection<FunctionResponseType> var1);

        public Builder functionResponseTypes(FunctionResponseType ... var1);

        public Builder amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig var1);

        default public Builder amazonManagedKafkaEventSourceConfig(Consumer<AmazonManagedKafkaEventSourceConfig.Builder> amazonManagedKafkaEventSourceConfig) {
            return this.amazonManagedKafkaEventSourceConfig((AmazonManagedKafkaEventSourceConfig)((AmazonManagedKafkaEventSourceConfig.Builder)AmazonManagedKafkaEventSourceConfig.builder().applyMutation(amazonManagedKafkaEventSourceConfig)).build());
        }

        public Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig var1);

        default public Builder selfManagedKafkaEventSourceConfig(Consumer<SelfManagedKafkaEventSourceConfig.Builder> selfManagedKafkaEventSourceConfig) {
            return this.selfManagedKafkaEventSourceConfig((SelfManagedKafkaEventSourceConfig)((SelfManagedKafkaEventSourceConfig.Builder)SelfManagedKafkaEventSourceConfig.builder().applyMutation(selfManagedKafkaEventSourceConfig)).build());
        }

        public Builder scalingConfig(ScalingConfig var1);

        default public Builder scalingConfig(Consumer<ScalingConfig.Builder> scalingConfig) {
            return this.scalingConfig((ScalingConfig)((ScalingConfig.Builder)ScalingConfig.builder().applyMutation(scalingConfig)).build());
        }

        public Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig var1);

        default public Builder documentDBEventSourceConfig(Consumer<DocumentDBEventSourceConfig.Builder> documentDBEventSourceConfig) {
            return this.documentDBEventSourceConfig((DocumentDBEventSourceConfig)((DocumentDBEventSourceConfig.Builder)DocumentDBEventSourceConfig.builder().applyMutation(documentDBEventSourceConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder filterCriteriaError(FilterCriteriaError var1);

        default public Builder filterCriteriaError(Consumer<FilterCriteriaError.Builder> filterCriteriaError) {
            return this.filterCriteriaError((FilterCriteriaError)((FilterCriteriaError.Builder)FilterCriteriaError.builder().applyMutation(filterCriteriaError)).build());
        }

        public Builder eventSourceMappingArn(String var1);

        public Builder metricsConfig(EventSourceMappingMetricsConfig var1);

        default public Builder metricsConfig(Consumer<EventSourceMappingMetricsConfig.Builder> metricsConfig) {
            return this.metricsConfig((EventSourceMappingMetricsConfig)((EventSourceMappingMetricsConfig.Builder)EventSourceMappingMetricsConfig.builder().applyMutation(metricsConfig)).build());
        }

        public Builder provisionedPollerConfig(ProvisionedPollerConfig var1);

        default public Builder provisionedPollerConfig(Consumer<ProvisionedPollerConfig.Builder> provisionedPollerConfig) {
            return this.provisionedPollerConfig((ProvisionedPollerConfig)((ProvisionedPollerConfig.Builder)ProvisionedPollerConfig.builder().applyMutation(provisionedPollerConfig)).build());
        }
    }
}

