/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayerVersionContentOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayerVersionContentOutput> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::location)).setter(LayerVersionContentOutput.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSha256").getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::codeSha256)).setter(LayerVersionContentOutput.setter(Builder::codeSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()}).build();
    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeSize").getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::codeSize)).setter(LayerVersionContentOutput.setter(Builder::codeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()}).build();
    private static final SdkField<String> SIGNING_PROFILE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningProfileVersionArn").getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::signingProfileVersionArn)).setter(LayerVersionContentOutput.setter(Builder::signingProfileVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProfileVersionArn").build()}).build();
    private static final SdkField<String> SIGNING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningJobArn").getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::signingJobArn)).setter(LayerVersionContentOutput.setter(Builder::signingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningJobArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, CODE_SHA256_FIELD, CODE_SIZE_FIELD, SIGNING_PROFILE_VERSION_ARN_FIELD, SIGNING_JOB_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LayerVersionContentOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String location;
    private final String codeSha256;
    private final Long codeSize;
    private final String signingProfileVersionArn;
    private final String signingJobArn;

    private LayerVersionContentOutput(BuilderImpl builder) {
        this.location = builder.location;
        this.codeSha256 = builder.codeSha256;
        this.codeSize = builder.codeSize;
        this.signingProfileVersionArn = builder.signingProfileVersionArn;
        this.signingJobArn = builder.signingJobArn;
    }

    public final String location() {
        return this.location;
    }

    public final String codeSha256() {
        return this.codeSha256;
    }

    public final Long codeSize() {
        return this.codeSize;
    }

    public final String signingProfileVersionArn() {
        return this.signingProfileVersionArn;
    }

    public final String signingJobArn() {
        return this.signingJobArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingProfileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingJobArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerVersionContentOutput)) {
            return false;
        }
        LayerVersionContentOutput other = (LayerVersionContentOutput)obj;
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.codeSize(), other.codeSize()) && Objects.equals(this.signingProfileVersionArn(), other.signingProfileVersionArn()) && Objects.equals(this.signingJobArn(), other.signingJobArn());
    }

    public final String toString() {
        return ToString.builder((String)"LayerVersionContentOutput").add("Location", (Object)this.location()).add("CodeSha256", (Object)this.codeSha256()).add("CodeSize", (Object)this.codeSize()).add("SigningProfileVersionArn", (Object)this.signingProfileVersionArn()).add("SigningJobArn", (Object)this.signingJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "CodeSha256": {
                return Optional.ofNullable(clazz.cast(this.codeSha256()));
            }
            case "CodeSize": {
                return Optional.ofNullable(clazz.cast(this.codeSize()));
            }
            case "SigningProfileVersionArn": {
                return Optional.ofNullable(clazz.cast(this.signingProfileVersionArn()));
            }
            case "SigningJobArn": {
                return Optional.ofNullable(clazz.cast(this.signingJobArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Location", LOCATION_FIELD);
        map.put("CodeSha256", CODE_SHA256_FIELD);
        map.put("CodeSize", CODE_SIZE_FIELD);
        map.put("SigningProfileVersionArn", SIGNING_PROFILE_VERSION_ARN_FIELD);
        map.put("SigningJobArn", SIGNING_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayerVersionContentOutput, T> g) {
        return obj -> g.apply((LayerVersionContentOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private String codeSha256;
        private Long codeSize;
        private String signingProfileVersionArn;
        private String signingJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerVersionContentOutput model) {
            this.location(model.location);
            this.codeSha256(model.codeSha256);
            this.codeSize(model.codeSize);
            this.signingProfileVersionArn(model.signingProfileVersionArn);
            this.signingJobArn(model.signingJobArn);
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final String getSigningProfileVersionArn() {
            return this.signingProfileVersionArn;
        }

        public final void setSigningProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
        }

        @Override
        public final Builder signingProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
            return this;
        }

        public final String getSigningJobArn() {
            return this.signingJobArn;
        }

        public final void setSigningJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
        }

        @Override
        public final Builder signingJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
            return this;
        }

        public LayerVersionContentOutput build() {
            return new LayerVersionContentOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayerVersionContentOutput> {
        public Builder location(String var1);

        public Builder codeSha256(String var1);

        public Builder codeSize(Long var1);

        public Builder signingProfileVersionArn(String var1);

        public Builder signingJobArn(String var1);
    }
}

