/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;

public class ListFunctionsPublisher
implements SdkPublisher<ListFunctionsResponse> {
    private final LambdaAsyncClient client;
    private final ListFunctionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFunctionsPublisher(LambdaAsyncClient client, ListFunctionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFunctionsPublisher(LambdaAsyncClient client, ListFunctionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFunctionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFunctionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FunctionConfiguration> functions() {
        Function<ListFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functions() != null) {
                return response.functions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFunctionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListFunctionsPublisher resume(ListFunctionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFunctionsPublisher(this.client, (ListFunctionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListFunctionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListFunctionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListFunctionsResponseFetcher
    implements AsyncPageFetcher<ListFunctionsResponse> {
        private ListFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFunctionsResponse> nextPage(ListFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsPublisher.this.client.listFunctions(ListFunctionsPublisher.this.firstRequest);
            }
            return ListFunctionsPublisher.this.client.listFunctions((ListFunctionsRequest)((Object)ListFunctionsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

