/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.SnapStartApplyOn;
import software.amazon.awssdk.services.lambda.model.SnapStartOptimizationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapStartResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapStartResponse> {
    private static final SdkField<String> APPLY_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplyOn").getter(SnapStartResponse.getter(SnapStartResponse::applyOnAsString)).setter(SnapStartResponse.setter(Builder::applyOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOn").build()}).build();
    private static final SdkField<String> OPTIMIZATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationStatus").getter(SnapStartResponse.getter(SnapStartResponse::optimizationStatusAsString)).setter(SnapStartResponse.setter(Builder::optimizationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLY_ON_FIELD, OPTIMIZATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplyOn", APPLY_ON_FIELD);
            this.put("OptimizationStatus", OPTIMIZATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applyOn;
    private final String optimizationStatus;

    private SnapStartResponse(BuilderImpl builder) {
        this.applyOn = builder.applyOn;
        this.optimizationStatus = builder.optimizationStatus;
    }

    public final SnapStartApplyOn applyOn() {
        return SnapStartApplyOn.fromValue(this.applyOn);
    }

    public final String applyOnAsString() {
        return this.applyOn;
    }

    public final SnapStartOptimizationStatus optimizationStatus() {
        return SnapStartOptimizationStatus.fromValue(this.optimizationStatus);
    }

    public final String optimizationStatusAsString() {
        return this.optimizationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapStartResponse)) {
            return false;
        }
        SnapStartResponse other = (SnapStartResponse)obj;
        return Objects.equals(this.applyOnAsString(), other.applyOnAsString()) && Objects.equals(this.optimizationStatusAsString(), other.optimizationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SnapStartResponse").add("ApplyOn", (Object)this.applyOnAsString()).add("OptimizationStatus", (Object)this.optimizationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplyOn": {
                return Optional.ofNullable(clazz.cast(this.applyOnAsString()));
            }
            case "OptimizationStatus": {
                return Optional.ofNullable(clazz.cast(this.optimizationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SnapStartResponse, T> g) {
        return obj -> g.apply((SnapStartResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applyOn;
        private String optimizationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapStartResponse model) {
            this.applyOn(model.applyOn);
            this.optimizationStatus(model.optimizationStatus);
        }

        public final String getApplyOn() {
            return this.applyOn;
        }

        public final void setApplyOn(String applyOn) {
            this.applyOn = applyOn;
        }

        @Override
        public final Builder applyOn(String applyOn) {
            this.applyOn = applyOn;
            return this;
        }

        @Override
        public final Builder applyOn(SnapStartApplyOn applyOn) {
            this.applyOn(applyOn == null ? null : applyOn.toString());
            return this;
        }

        public final String getOptimizationStatus() {
            return this.optimizationStatus;
        }

        public final void setOptimizationStatus(String optimizationStatus) {
            this.optimizationStatus = optimizationStatus;
        }

        @Override
        public final Builder optimizationStatus(String optimizationStatus) {
            this.optimizationStatus = optimizationStatus;
            return this;
        }

        @Override
        public final Builder optimizationStatus(SnapStartOptimizationStatus optimizationStatus) {
            this.optimizationStatus(optimizationStatus == null ? null : optimizationStatus.toString());
            return this;
        }

        public SnapStartResponse build() {
            return new SnapStartResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapStartResponse> {
        public Builder applyOn(String var1);

        public Builder applyOn(SnapStartApplyOn var1);

        public Builder optimizationStatus(String var1);

        public Builder optimizationStatus(SnapStartOptimizationStatus var1);
    }
}

