/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.Concurrency;
import software.amazon.awssdk.services.lambda.model.FunctionCodeLocation;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.services.lambda.model.TagsError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFunctionResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, GetFunctionResponse> {
    private static final SdkField<FunctionConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(GetFunctionResponse.getter(GetFunctionResponse::configuration)).setter(GetFunctionResponse.setter(Builder::configuration)).constructor(FunctionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<FunctionCodeLocation> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(GetFunctionResponse.getter(GetFunctionResponse::code)).setter(GetFunctionResponse.setter(Builder::code)).constructor(FunctionCodeLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetFunctionResponse.getter(GetFunctionResponse::tags)).setter(GetFunctionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TagsError> TAGS_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagsError").getter(GetFunctionResponse.getter(GetFunctionResponse::tagsError)).setter(GetFunctionResponse.setter(Builder::tagsError)).constructor(TagsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsError").build()}).build();
    private static final SdkField<Concurrency> CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Concurrency").getter(GetFunctionResponse.getter(GetFunctionResponse::concurrency)).setter(GetFunctionResponse.setter(Builder::concurrency)).constructor(Concurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Concurrency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, CODE_FIELD, TAGS_FIELD, TAGS_ERROR_FIELD, CONCURRENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Configuration", CONFIGURATION_FIELD);
            this.put("Code", CODE_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("TagsError", TAGS_ERROR_FIELD);
            this.put("Concurrency", CONCURRENCY_FIELD);
        }
    });
    private final FunctionConfiguration configuration;
    private final FunctionCodeLocation code;
    private final Map<String, String> tags;
    private final TagsError tagsError;
    private final Concurrency concurrency;

    private GetFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.code = builder.code;
        this.tags = builder.tags;
        this.tagsError = builder.tagsError;
        this.concurrency = builder.concurrency;
    }

    public final FunctionConfiguration configuration() {
        return this.configuration;
    }

    public final FunctionCodeLocation code() {
        return this.code;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TagsError tagsError() {
        return this.tagsError;
    }

    public final Concurrency concurrency() {
        return this.concurrency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsError());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.code(), other.code()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tagsError(), other.tagsError()) && Objects.equals(this.concurrency(), other.concurrency());
    }

    public final String toString() {
        return ToString.builder((String)"GetFunctionResponse").add("Configuration", (Object)this.configuration()).add("Code", (Object)this.code()).add("Tags", this.hasTags() ? this.tags() : null).add("TagsError", (Object)this.tagsError()).add("Concurrency", (Object)this.concurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TagsError": {
                return Optional.ofNullable(clazz.cast(this.tagsError()));
            }
            case "Concurrency": {
                return Optional.ofNullable(clazz.cast(this.concurrency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionResponse, T> g) {
        return obj -> g.apply((GetFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private FunctionConfiguration configuration;
        private FunctionCodeLocation code;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TagsError tagsError;
        private Concurrency concurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            super(model);
            this.configuration(model.configuration);
            this.code(model.code);
            this.tags(model.tags);
            this.tagsError(model.tagsError);
            this.concurrency(model.concurrency);
        }

        public final FunctionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(FunctionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FunctionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final FunctionCodeLocation.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(FunctionCodeLocation.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(FunctionCodeLocation code) {
            this.code = code;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final TagsError.Builder getTagsError() {
            return this.tagsError != null ? this.tagsError.toBuilder() : null;
        }

        public final void setTagsError(TagsError.BuilderImpl tagsError) {
            this.tagsError = tagsError != null ? tagsError.build() : null;
        }

        @Override
        public final Builder tagsError(TagsError tagsError) {
            this.tagsError = tagsError;
            return this;
        }

        public final Concurrency.Builder getConcurrency() {
            return this.concurrency != null ? this.concurrency.toBuilder() : null;
        }

        public final void setConcurrency(Concurrency.BuilderImpl concurrency) {
            this.concurrency = concurrency != null ? concurrency.build() : null;
        }

        @Override
        public final Builder concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        @Override
        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFunctionResponse> {
        public Builder configuration(FunctionConfiguration var1);

        default public Builder configuration(Consumer<FunctionConfiguration.Builder> configuration) {
            return this.configuration((FunctionConfiguration)((FunctionConfiguration.Builder)FunctionConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder code(FunctionCodeLocation var1);

        default public Builder code(Consumer<FunctionCodeLocation.Builder> code) {
            return this.code((FunctionCodeLocation)((FunctionCodeLocation.Builder)FunctionCodeLocation.builder().applyMutation(code)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder tagsError(TagsError var1);

        default public Builder tagsError(Consumer<TagsError.Builder> tagsError) {
            return this.tagsError((TagsError)((TagsError.Builder)TagsError.builder().applyMutation(tagsError)).build());
        }

        public Builder concurrency(Concurrency var1);

        default public Builder concurrency(Consumer<Concurrency.Builder> concurrency) {
            return this.concurrency((Concurrency)((Concurrency.Builder)Concurrency.builder().applyMutation(concurrency)).build());
        }
    }
}

