/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedConcurrencyConfigListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedConcurrencyConfigListItem> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::functionArn)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<Integer> REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestedProvisionedConcurrentExecutions").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::requestedProvisionedConcurrentExecutions)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::requestedProvisionedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedProvisionedConcurrentExecutions").build()}).build();
    private static final SdkField<Integer> AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableProvisionedConcurrentExecutions").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::availableProvisionedConcurrentExecutions)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::availableProvisionedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProvisionedConcurrentExecutions").build()}).build();
    private static final SdkField<Integer> ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedProvisionedConcurrentExecutions").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::allocatedProvisionedConcurrentExecutions)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::allocatedProvisionedConcurrentExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedProvisionedConcurrentExecutions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::statusAsString)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::statusReason)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(ProvisionedConcurrencyConfigListItem.getter(ProvisionedConcurrencyConfigListItem::lastModified)).setter(ProvisionedConcurrencyConfigListItem.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAST_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FunctionArn", FUNCTION_ARN_FIELD);
            this.put("RequestedProvisionedConcurrentExecutions", REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD);
            this.put("AvailableProvisionedConcurrentExecutions", AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD);
            this.put("AllocatedProvisionedConcurrentExecutions", ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
            this.put("LastModified", LAST_MODIFIED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String functionArn;
    private final Integer requestedProvisionedConcurrentExecutions;
    private final Integer availableProvisionedConcurrentExecutions;
    private final Integer allocatedProvisionedConcurrentExecutions;
    private final String status;
    private final String statusReason;
    private final String lastModified;

    private ProvisionedConcurrencyConfigListItem(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.requestedProvisionedConcurrentExecutions = builder.requestedProvisionedConcurrentExecutions;
        this.availableProvisionedConcurrentExecutions = builder.availableProvisionedConcurrentExecutions;
        this.allocatedProvisionedConcurrentExecutions = builder.allocatedProvisionedConcurrentExecutions;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastModified = builder.lastModified;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final Integer requestedProvisionedConcurrentExecutions() {
        return this.requestedProvisionedConcurrentExecutions;
    }

    public final Integer availableProvisionedConcurrentExecutions() {
        return this.availableProvisionedConcurrentExecutions;
    }

    public final Integer allocatedProvisionedConcurrentExecutions() {
        return this.allocatedProvisionedConcurrentExecutions;
    }

    public final ProvisionedConcurrencyStatusEnum status() {
        return ProvisionedConcurrencyStatusEnum.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedConcurrencyConfigListItem)) {
            return false;
        }
        ProvisionedConcurrencyConfigListItem other = (ProvisionedConcurrencyConfigListItem)obj;
        return Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.requestedProvisionedConcurrentExecutions(), other.requestedProvisionedConcurrentExecutions()) && Objects.equals(this.availableProvisionedConcurrentExecutions(), other.availableProvisionedConcurrentExecutions()) && Objects.equals(this.allocatedProvisionedConcurrentExecutions(), other.allocatedProvisionedConcurrentExecutions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.lastModified(), other.lastModified());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedConcurrencyConfigListItem").add("FunctionArn", (Object)this.functionArn()).add("RequestedProvisionedConcurrentExecutions", (Object)this.requestedProvisionedConcurrentExecutions()).add("AvailableProvisionedConcurrentExecutions", (Object)this.availableProvisionedConcurrentExecutions()).add("AllocatedProvisionedConcurrentExecutions", (Object)this.allocatedProvisionedConcurrentExecutions()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("LastModified", (Object)this.lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "RequestedProvisionedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.requestedProvisionedConcurrentExecutions()));
            }
            case "AvailableProvisionedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.availableProvisionedConcurrentExecutions()));
            }
            case "AllocatedProvisionedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.allocatedProvisionedConcurrentExecutions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedConcurrencyConfigListItem, T> g) {
        return obj -> g.apply((ProvisionedConcurrencyConfigListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionArn;
        private Integer requestedProvisionedConcurrentExecutions;
        private Integer availableProvisionedConcurrentExecutions;
        private Integer allocatedProvisionedConcurrentExecutions;
        private String status;
        private String statusReason;
        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedConcurrencyConfigListItem model) {
            this.functionArn(model.functionArn);
            this.requestedProvisionedConcurrentExecutions(model.requestedProvisionedConcurrentExecutions);
            this.availableProvisionedConcurrentExecutions(model.availableProvisionedConcurrentExecutions);
            this.allocatedProvisionedConcurrentExecutions(model.allocatedProvisionedConcurrentExecutions);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.lastModified(model.lastModified);
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final Integer getRequestedProvisionedConcurrentExecutions() {
            return this.requestedProvisionedConcurrentExecutions;
        }

        public final void setRequestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder requestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
            return this;
        }

        public final Integer getAvailableProvisionedConcurrentExecutions() {
            return this.availableProvisionedConcurrentExecutions;
        }

        public final void setAvailableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder availableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
            return this;
        }

        public final Integer getAllocatedProvisionedConcurrentExecutions() {
            return this.allocatedProvisionedConcurrentExecutions;
        }

        public final void setAllocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder allocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedConcurrencyStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public ProvisionedConcurrencyConfigListItem build() {
            return new ProvisionedConcurrencyConfigListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedConcurrencyConfigListItem> {
        public Builder functionArn(String var1);

        public Builder requestedProvisionedConcurrentExecutions(Integer var1);

        public Builder availableProvisionedConcurrentExecutions(Integer var1);

        public Builder allocatedProvisionedConcurrentExecutions(Integer var1);

        public Builder status(String var1);

        public Builder status(ProvisionedConcurrencyStatusEnum var1);

        public Builder statusReason(String var1);

        public Builder lastModified(String var1);
    }
}

