/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPublicAccessBlockConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<PutPublicAccessBlockConfigRequest.Builder, PutPublicAccessBlockConfigRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PutPublicAccessBlockConfigRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceArn").build()).build();

    private static final SdkField<PublicAccessBlockConfig> PUBLIC_ACCESS_BLOCK_CONFIG_FIELD = SdkField
            .<PublicAccessBlockConfig> builder(MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfig")
            .getter(getter(PutPublicAccessBlockConfigRequest::publicAccessBlockConfig))
            .setter(setter(Builder::publicAccessBlockConfig)).constructor(PublicAccessBlockConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            PUBLIC_ACCESS_BLOCK_CONFIG_FIELD));

    private final String resourceArn;

    private final PublicAccessBlockConfig publicAccessBlockConfig;

    private PutPublicAccessBlockConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.publicAccessBlockConfig = builder.publicAccessBlockConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function you want to configure public-access settings for. Public-access
     * settings are applied at the function level, so you can't apply different settings to function versions or
     * aliases.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function you want to configure public-access settings for.
     *         Public-access settings are applied at the function level, so you can't apply different settings to
     *         function versions or aliases.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * An object defining the public-access settings you want to apply.
     * </p>
     * <p>
     * To block the creation of resource-based policies that would grant public access to your function, set
     * <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies that would
     * grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>.
     * </p>
     * <p>
     * To block public access to your function, even if its resource-based policy allows it, set
     * <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
     * resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
     * </p>
     * <p>
     * The default setting for both <code>BlockPublicPolicy</code> and <code>RestrictPublicResource</code> is
     * <code>true</code>.
     * </p>
     * 
     * @return An object defining the public-access settings you want to apply.</p>
     *         <p>
     *         To block the creation of resource-based policies that would grant public access to your function, set
     *         <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies
     *         that would grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>
     *         .
     *         </p>
     *         <p>
     *         To block public access to your function, even if its resource-based policy allows it, set
     *         <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
     *         resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
     *         </p>
     *         <p>
     *         The default setting for both <code>BlockPublicPolicy</code> and <code>RestrictPublicResource</code> is
     *         <code>true</code>.
     */
    public final PublicAccessBlockConfig publicAccessBlockConfig() {
        return publicAccessBlockConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPublicAccessBlockConfigRequest)) {
            return false;
        }
        PutPublicAccessBlockConfigRequest other = (PutPublicAccessBlockConfigRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(publicAccessBlockConfig(), other.publicAccessBlockConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPublicAccessBlockConfigRequest").add("ResourceArn", resourceArn())
                .add("PublicAccessBlockConfig", publicAccessBlockConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "PublicAccessBlockConfig":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPublicAccessBlockConfigRequest, T> g) {
        return obj -> g.apply((PutPublicAccessBlockConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPublicAccessBlockConfigRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function you want to configure public-access settings for.
         * Public-access settings are applied at the function level, so you can't apply different settings to function
         * versions or aliases.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the function you want to configure public-access settings for.
         *        Public-access settings are applied at the function level, so you can't apply different settings to
         *        function versions or aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An object defining the public-access settings you want to apply.
         * </p>
         * <p>
         * To block the creation of resource-based policies that would grant public access to your function, set
         * <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies that
         * would grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>.
         * </p>
         * <p>
         * To block public access to your function, even if its resource-based policy allows it, set
         * <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
         * resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
         * </p>
         * <p>
         * The default setting for both <code>BlockPublicPolicy</code> and <code>RestrictPublicResource</code> is
         * <code>true</code>.
         * </p>
         * 
         * @param publicAccessBlockConfig
         *        An object defining the public-access settings you want to apply.</p>
         *        <p>
         *        To block the creation of resource-based policies that would grant public access to your function, set
         *        <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies
         *        that would grant public access to your function, set <code>BlockPublicPolicy</code> to
         *        <code>false</code>.
         *        </p>
         *        <p>
         *        To block public access to your function, even if its resource-based policy allows it, set
         *        <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
         *        resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
         *        </p>
         *        <p>
         *        The default setting for both <code>BlockPublicPolicy</code> and <code>RestrictPublicResource</code> is
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfig(PublicAccessBlockConfig publicAccessBlockConfig);

        /**
         * <p>
         * An object defining the public-access settings you want to apply.
         * </p>
         * <p>
         * To block the creation of resource-based policies that would grant public access to your function, set
         * <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies that
         * would grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>.
         * </p>
         * <p>
         * To block public access to your function, even if its resource-based policy allows it, set
         * <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
         * resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
         * </p>
         * <p>
         * The default setting for both <code>BlockPublicPolicy</code> and <code>RestrictPublicResource</code> is
         * <code>true</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicAccessBlockConfig.Builder} avoiding
         * the need to create one manually via {@link PublicAccessBlockConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicAccessBlockConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #publicAccessBlockConfig(PublicAccessBlockConfig)}.
         * 
         * @param publicAccessBlockConfig
         *        a consumer that will call methods on {@link PublicAccessBlockConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfig(PublicAccessBlockConfig)
         */
        default Builder publicAccessBlockConfig(Consumer<PublicAccessBlockConfig.Builder> publicAccessBlockConfig) {
            return publicAccessBlockConfig(PublicAccessBlockConfig.builder().applyMutation(publicAccessBlockConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private PublicAccessBlockConfig publicAccessBlockConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPublicAccessBlockConfigRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            publicAccessBlockConfig(model.publicAccessBlockConfig);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final PublicAccessBlockConfig.Builder getPublicAccessBlockConfig() {
            return publicAccessBlockConfig != null ? publicAccessBlockConfig.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfig(PublicAccessBlockConfig.BuilderImpl publicAccessBlockConfig) {
            this.publicAccessBlockConfig = publicAccessBlockConfig != null ? publicAccessBlockConfig.build() : null;
        }

        @Override
        public final Builder publicAccessBlockConfig(PublicAccessBlockConfig publicAccessBlockConfig) {
            this.publicAccessBlockConfig = publicAccessBlockConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPublicAccessBlockConfigRequest build() {
            return new PutPublicAccessBlockConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
