/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the public-access settings for a function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicAccessBlockConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicAccessBlockConfig.Builder, PublicAccessBlockConfig> {
    private static final SdkField<Boolean> BLOCK_PUBLIC_POLICY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BlockPublicPolicy").getter(getter(PublicAccessBlockConfig::blockPublicPolicy))
            .setter(setter(Builder::blockPublicPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicPolicy").build()).build();

    private static final SdkField<Boolean> RESTRICT_PUBLIC_RESOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RestrictPublicResource").getter(getter(PublicAccessBlockConfig::restrictPublicResource))
            .setter(setter(Builder::restrictPublicResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictPublicResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_PUBLIC_POLICY_FIELD,
            RESTRICT_PUBLIC_RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean blockPublicPolicy;

    private final Boolean restrictPublicResource;

    private PublicAccessBlockConfig(BuilderImpl builder) {
        this.blockPublicPolicy = builder.blockPublicPolicy;
        this.restrictPublicResource = builder.restrictPublicResource;
    }

    /**
     * <p>
     * To block the creation of resource-based policies that would grant public access to your function, set
     * <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies that would
     * grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>.
     * </p>
     * 
     * @return To block the creation of resource-based policies that would grant public access to your function, set
     *         <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies
     *         that would grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>
     *         .
     */
    public final Boolean blockPublicPolicy() {
        return blockPublicPolicy;
    }

    /**
     * <p>
     * To block public access to your function, even if its resource-based policy allows it, set
     * <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
     * resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
     * </p>
     * 
     * @return To block public access to your function, even if its resource-based policy allows it, set
     *         <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
     *         resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
     */
    public final Boolean restrictPublicResource() {
        return restrictPublicResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(restrictPublicResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicAccessBlockConfig)) {
            return false;
        }
        PublicAccessBlockConfig other = (PublicAccessBlockConfig) obj;
        return Objects.equals(blockPublicPolicy(), other.blockPublicPolicy())
                && Objects.equals(restrictPublicResource(), other.restrictPublicResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicAccessBlockConfig").add("BlockPublicPolicy", blockPublicPolicy())
                .add("RestrictPublicResource", restrictPublicResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockPublicPolicy":
            return Optional.ofNullable(clazz.cast(blockPublicPolicy()));
        case "RestrictPublicResource":
            return Optional.ofNullable(clazz.cast(restrictPublicResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicAccessBlockConfig, T> g) {
        return obj -> g.apply((PublicAccessBlockConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicAccessBlockConfig> {
        /**
         * <p>
         * To block the creation of resource-based policies that would grant public access to your function, set
         * <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies that
         * would grant public access to your function, set <code>BlockPublicPolicy</code> to <code>false</code>.
         * </p>
         * 
         * @param blockPublicPolicy
         *        To block the creation of resource-based policies that would grant public access to your function, set
         *        <code>BlockPublicPolicy</code> to <code>true</code>. To allow the creation of resource-based policies
         *        that would grant public access to your function, set <code>BlockPublicPolicy</code> to
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicPolicy(Boolean blockPublicPolicy);

        /**
         * <p>
         * To block public access to your function, even if its resource-based policy allows it, set
         * <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
         * resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
         * </p>
         * 
         * @param restrictPublicResource
         *        To block public access to your function, even if its resource-based policy allows it, set
         *        <code>RestrictPublicResource</code> to <code>true</code>. To allow public access to a function with a
         *        resource-based policy that permits it, set <code>RestrictPublicResource</code> to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictPublicResource(Boolean restrictPublicResource);
    }

    static final class BuilderImpl implements Builder {
        private Boolean blockPublicPolicy;

        private Boolean restrictPublicResource;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicAccessBlockConfig model) {
            blockPublicPolicy(model.blockPublicPolicy);
            restrictPublicResource(model.restrictPublicResource);
        }

        public final Boolean getBlockPublicPolicy() {
            return blockPublicPolicy;
        }

        public final void setBlockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
        }

        @Override
        public final Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            this.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        public final Boolean getRestrictPublicResource() {
            return restrictPublicResource;
        }

        public final void setRestrictPublicResource(Boolean restrictPublicResource) {
            this.restrictPublicResource = restrictPublicResource;
        }

        @Override
        public final Builder restrictPublicResource(Boolean restrictPublicResource) {
            this.restrictPublicResource = restrictPublicResource;
            return this;
        }

        @Override
        public PublicAccessBlockConfig build() {
            return new PublicAccessBlockConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
