/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
 * settings for your Lambda function URL. Use CORS to grant access to your function URL from any origin. You can also
 * use CORS to control access for specific HTTP headers and methods in requests to your function URL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cors implements SdkPojo, Serializable, ToCopyableBuilder<Cors.Builder, Cors> {
    private static final SdkField<Boolean> ALLOW_CREDENTIALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowCredentials").getter(getter(Cors::allowCredentials)).setter(setter(Builder::allowCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCredentials").build()).build();

    private static final SdkField<List<String>> ALLOW_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowHeaders")
            .getter(getter(Cors::allowHeaders))
            .setter(setter(Builder::allowHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOW_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowMethods")
            .getter(getter(Cors::allowMethods))
            .setter(setter(Builder::allowMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOW_ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowOrigins")
            .getter(getter(Cors::allowOrigins))
            .setter(setter(Builder::allowOrigins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowOrigins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExposeHeaders")
            .getter(getter(Cors::exposeHeaders))
            .setter(setter(Builder::exposeHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExposeHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAge").getter(getter(Cors::maxAge)).setter(setter(Builder::maxAge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_CREDENTIALS_FIELD,
            ALLOW_HEADERS_FIELD, ALLOW_METHODS_FIELD, ALLOW_ORIGINS_FIELD, EXPOSE_HEADERS_FIELD, MAX_AGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowCredentials;

    private final List<String> allowHeaders;

    private final List<String> allowMethods;

    private final List<String> allowOrigins;

    private final List<String> exposeHeaders;

    private final Integer maxAge;

    private Cors(BuilderImpl builder) {
        this.allowCredentials = builder.allowCredentials;
        this.allowHeaders = builder.allowHeaders;
        this.allowMethods = builder.allowMethods;
        this.allowOrigins = builder.allowOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAge = builder.maxAge;
    }

    /**
     * <p>
     * Whether to allow cookies or other credentials in requests to your function URL. The default is <code>false</code>
     * .
     * </p>
     * 
     * @return Whether to allow cookies or other credentials in requests to your function URL. The default is
     *         <code>false</code>.
     */
    public final Boolean allowCredentials() {
        return allowCredentials;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowHeaders() {
        return allowHeaders != null && !(allowHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The HTTP headers that origins can include in requests to your function URL. For example: <code>Date</code>,
     * <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowHeaders} method.
     * </p>
     * 
     * @return The HTTP headers that origins can include in requests to your function URL. For example:
     *         <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
     */
    public final List<String> allowHeaders() {
        return allowHeaders;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowMethods property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowMethods() {
        return allowMethods != null && !(allowMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>,
     * <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowMethods} method.
     * </p>
     * 
     * @return The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>,
     *         <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).
     */
    public final List<String> allowMethods() {
        return allowMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowOrigins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowOrigins() {
        return allowOrigins != null && !(allowOrigins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The origins that can access your function URL. You can list any number of specific origins, separated by a comma.
     * For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>.
     * </p>
     * <p>
     * Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowOrigins} method.
     * </p>
     * 
     * @return The origins that can access your function URL. You can list any number of specific origins, separated by
     *         a comma. For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>.</p>
     *         <p>
     *         Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).
     */
    public final List<String> allowOrigins() {
        return allowOrigins;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExposeHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExposeHeaders() {
        return exposeHeaders != null && !(exposeHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The HTTP headers in your function response that you want to expose to origins that call your function URL. For
     * example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExposeHeaders} method.
     * </p>
     * 
     * @return The HTTP headers in your function response that you want to expose to origins that call your function
     *         URL. For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
     */
    public final List<String> exposeHeaders() {
        return exposeHeaders;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default,
     * this is set to <code>0</code>, which means that the browser doesn't cache results.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By
     *         default, this is set to <code>0</code>, which means that the browser doesn't cache results.
     */
    public final Integer maxAge() {
        return maxAge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowHeaders() ? allowHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowMethods() ? allowMethods() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowOrigins() ? allowOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExposeHeaders() ? exposeHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxAge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cors)) {
            return false;
        }
        Cors other = (Cors) obj;
        return Objects.equals(allowCredentials(), other.allowCredentials()) && hasAllowHeaders() == other.hasAllowHeaders()
                && Objects.equals(allowHeaders(), other.allowHeaders()) && hasAllowMethods() == other.hasAllowMethods()
                && Objects.equals(allowMethods(), other.allowMethods()) && hasAllowOrigins() == other.hasAllowOrigins()
                && Objects.equals(allowOrigins(), other.allowOrigins()) && hasExposeHeaders() == other.hasExposeHeaders()
                && Objects.equals(exposeHeaders(), other.exposeHeaders()) && Objects.equals(maxAge(), other.maxAge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cors").add("AllowCredentials", allowCredentials())
                .add("AllowHeaders", hasAllowHeaders() ? allowHeaders() : null)
                .add("AllowMethods", hasAllowMethods() ? allowMethods() : null)
                .add("AllowOrigins", hasAllowOrigins() ? allowOrigins() : null)
                .add("ExposeHeaders", hasExposeHeaders() ? exposeHeaders() : null).add("MaxAge", maxAge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowCredentials":
            return Optional.ofNullable(clazz.cast(allowCredentials()));
        case "AllowHeaders":
            return Optional.ofNullable(clazz.cast(allowHeaders()));
        case "AllowMethods":
            return Optional.ofNullable(clazz.cast(allowMethods()));
        case "AllowOrigins":
            return Optional.ofNullable(clazz.cast(allowOrigins()));
        case "ExposeHeaders":
            return Optional.ofNullable(clazz.cast(exposeHeaders()));
        case "MaxAge":
            return Optional.ofNullable(clazz.cast(maxAge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cors, T> g) {
        return obj -> g.apply((Cors) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cors> {
        /**
         * <p>
         * Whether to allow cookies or other credentials in requests to your function URL. The default is
         * <code>false</code>.
         * </p>
         * 
         * @param allowCredentials
         *        Whether to allow cookies or other credentials in requests to your function URL. The default is
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCredentials(Boolean allowCredentials);

        /**
         * <p>
         * The HTTP headers that origins can include in requests to your function URL. For example: <code>Date</code>,
         * <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * </p>
         * 
         * @param allowHeaders
         *        The HTTP headers that origins can include in requests to your function URL. For example:
         *        <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowHeaders(Collection<String> allowHeaders);

        /**
         * <p>
         * The HTTP headers that origins can include in requests to your function URL. For example: <code>Date</code>,
         * <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * </p>
         * 
         * @param allowHeaders
         *        The HTTP headers that origins can include in requests to your function URL. For example:
         *        <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowHeaders(String... allowHeaders);

        /**
         * <p>
         * The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>,
         * <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).
         * </p>
         * 
         * @param allowMethods
         *        The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>,
         *        <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMethods(Collection<String> allowMethods);

        /**
         * <p>
         * The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>,
         * <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).
         * </p>
         * 
         * @param allowMethods
         *        The HTTP methods that are allowed when calling your function URL. For example: <code>GET</code>,
         *        <code>POST</code>, <code>DELETE</code>, or the wildcard character (<code>*</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMethods(String... allowMethods);

        /**
         * <p>
         * The origins that can access your function URL. You can list any number of specific origins, separated by a
         * comma. For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>.
         * </p>
         * <p>
         * Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).
         * </p>
         * 
         * @param allowOrigins
         *        The origins that can access your function URL. You can list any number of specific origins, separated
         *        by a comma. For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>
         *        .</p>
         *        <p>
         *        Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrigins(Collection<String> allowOrigins);

        /**
         * <p>
         * The origins that can access your function URL. You can list any number of specific origins, separated by a
         * comma. For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>.
         * </p>
         * <p>
         * Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).
         * </p>
         * 
         * @param allowOrigins
         *        The origins that can access your function URL. You can list any number of specific origins, separated
         *        by a comma. For example: <code>https://www.example.com</code>, <code>http://localhost:60905</code>
         *        .</p>
         *        <p>
         *        Alternatively, you can grant access to all origins using the wildcard character (<code>*</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrigins(String... allowOrigins);

        /**
         * <p>
         * The HTTP headers in your function response that you want to expose to origins that call your function URL.
         * For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * </p>
         * 
         * @param exposeHeaders
         *        The HTTP headers in your function response that you want to expose to origins that call your function
         *        URL. For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(Collection<String> exposeHeaders);

        /**
         * <p>
         * The HTTP headers in your function response that you want to expose to origins that call your function URL.
         * For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * </p>
         * 
         * @param exposeHeaders
         *        The HTTP headers in your function response that you want to expose to origins that call your function
         *        URL. For example: <code>Date</code>, <code>Keep-Alive</code>, <code>X-Custom-Header</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(String... exposeHeaders);

        /**
         * <p>
         * The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By
         * default, this is set to <code>0</code>, which means that the browser doesn't cache results.
         * </p>
         * 
         * @param maxAge
         *        The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By
         *        default, this is set to <code>0</code>, which means that the browser doesn't cache results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAge(Integer maxAge);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowCredentials;

        private List<String> allowHeaders = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowMethods = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowOrigins = DefaultSdkAutoConstructList.getInstance();

        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();

        private Integer maxAge;

        private BuilderImpl() {
        }

        private BuilderImpl(Cors model) {
            allowCredentials(model.allowCredentials);
            allowHeaders(model.allowHeaders);
            allowMethods(model.allowMethods);
            allowOrigins(model.allowOrigins);
            exposeHeaders(model.exposeHeaders);
            maxAge(model.maxAge);
        }

        public final Boolean getAllowCredentials() {
            return allowCredentials;
        }

        public final void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        @Override
        public final Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public final Collection<String> getAllowHeaders() {
            if (allowHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return allowHeaders;
        }

        public final void setAllowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = HeadersListCopier.copy(allowHeaders);
        }

        @Override
        public final Builder allowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = HeadersListCopier.copy(allowHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowHeaders(String... allowHeaders) {
            allowHeaders(Arrays.asList(allowHeaders));
            return this;
        }

        public final Collection<String> getAllowMethods() {
            if (allowMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return allowMethods;
        }

        public final void setAllowMethods(Collection<String> allowMethods) {
            this.allowMethods = AllowMethodsListCopier.copy(allowMethods);
        }

        @Override
        public final Builder allowMethods(Collection<String> allowMethods) {
            this.allowMethods = AllowMethodsListCopier.copy(allowMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowMethods(String... allowMethods) {
            allowMethods(Arrays.asList(allowMethods));
            return this;
        }

        public final Collection<String> getAllowOrigins() {
            if (allowOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return allowOrigins;
        }

        public final void setAllowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = AllowOriginsListCopier.copy(allowOrigins);
        }

        @Override
        public final Builder allowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = AllowOriginsListCopier.copy(allowOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowOrigins(String... allowOrigins) {
            allowOrigins(Arrays.asList(allowOrigins));
            return this;
        }

        public final Collection<String> getExposeHeaders() {
            if (exposeHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return exposeHeaders;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = HeadersListCopier.copy(exposeHeaders);
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = HeadersListCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String... exposeHeaders) {
            exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final Integer getMaxAge() {
            return maxAge;
        }

        public final void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        @Override
        public final Builder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        @Override
        public Cors build() {
            return new Cors(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
