/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.FunctionUrlConfig;
import software.amazon.awssdk.services.lambda.model.FunctionUrlConfigListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionUrlConfigsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListFunctionUrlConfigsResponse> {
    private static final SdkField<List<FunctionUrlConfig>> FUNCTION_URL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionUrlConfigs").getter(ListFunctionUrlConfigsResponse.getter(ListFunctionUrlConfigsResponse::functionUrlConfigs)).setter(ListFunctionUrlConfigsResponse.setter(Builder::functionUrlConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionUrlConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionUrlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListFunctionUrlConfigsResponse.getter(ListFunctionUrlConfigsResponse::nextMarker)).setter(ListFunctionUrlConfigsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_URL_CONFIGS_FIELD, NEXT_MARKER_FIELD));
    private final List<FunctionUrlConfig> functionUrlConfigs;
    private final String nextMarker;

    private ListFunctionUrlConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.functionUrlConfigs = builder.functionUrlConfigs;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasFunctionUrlConfigs() {
        return this.functionUrlConfigs != null && !(this.functionUrlConfigs instanceof SdkAutoConstructList);
    }

    public final List<FunctionUrlConfig> functionUrlConfigs() {
        return this.functionUrlConfigs;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionUrlConfigs() ? this.functionUrlConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionUrlConfigsResponse)) {
            return false;
        }
        ListFunctionUrlConfigsResponse other = (ListFunctionUrlConfigsResponse)((Object)obj);
        return this.hasFunctionUrlConfigs() == other.hasFunctionUrlConfigs() && Objects.equals(this.functionUrlConfigs(), other.functionUrlConfigs()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListFunctionUrlConfigsResponse").add("FunctionUrlConfigs", this.hasFunctionUrlConfigs() ? this.functionUrlConfigs() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionUrlConfigs": {
                return Optional.ofNullable(clazz.cast(this.functionUrlConfigs()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionUrlConfigsResponse, T> g) {
        return obj -> g.apply((ListFunctionUrlConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private List<FunctionUrlConfig> functionUrlConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionUrlConfigsResponse model) {
            super(model);
            this.functionUrlConfigs(model.functionUrlConfigs);
            this.nextMarker(model.nextMarker);
        }

        public final List<FunctionUrlConfig.Builder> getFunctionUrlConfigs() {
            List<FunctionUrlConfig.Builder> result = FunctionUrlConfigListCopier.copyToBuilder(this.functionUrlConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionUrlConfigs(Collection<FunctionUrlConfig.BuilderImpl> functionUrlConfigs) {
            this.functionUrlConfigs = FunctionUrlConfigListCopier.copyFromBuilder(functionUrlConfigs);
        }

        @Override
        public final Builder functionUrlConfigs(Collection<FunctionUrlConfig> functionUrlConfigs) {
            this.functionUrlConfigs = FunctionUrlConfigListCopier.copy(functionUrlConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionUrlConfigs(FunctionUrlConfig ... functionUrlConfigs) {
            this.functionUrlConfigs(Arrays.asList(functionUrlConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionUrlConfigs(Consumer<FunctionUrlConfig.Builder> ... functionUrlConfigs) {
            this.functionUrlConfigs(Stream.of(functionUrlConfigs).map(c -> (FunctionUrlConfig)((FunctionUrlConfig.Builder)FunctionUrlConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListFunctionUrlConfigsResponse build() {
            return new ListFunctionUrlConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionUrlConfigsResponse> {
        public Builder functionUrlConfigs(Collection<FunctionUrlConfig> var1);

        public Builder functionUrlConfigs(FunctionUrlConfig ... var1);

        public Builder functionUrlConfigs(Consumer<FunctionUrlConfig.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

