/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.DefaultLambdaAsyncClient;
import software.amazon.awssdk.services.lambda.DefaultLambdaBaseClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaServiceClientConfiguration;
import software.amazon.awssdk.services.lambda.endpoints.LambdaEndpointProvider;

@SdkInternalApi
final class DefaultLambdaAsyncClientBuilder
extends DefaultLambdaBaseClientBuilder<LambdaAsyncClientBuilder, LambdaAsyncClient>
implements LambdaAsyncClientBuilder {
    DefaultLambdaAsyncClientBuilder() {
    }

    @Override
    public DefaultLambdaAsyncClientBuilder endpointProvider(LambdaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LambdaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLambdaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LambdaServiceClientConfiguration serviceClientConfiguration = LambdaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultLambdaAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

