/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AliasConfiguration> {
    private static final SdkField<String> ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasArn").getter(AliasConfiguration.getter(AliasConfiguration::aliasArn)).setter(AliasConfiguration.setter(Builder::aliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AliasConfiguration.getter(AliasConfiguration::name)).setter(AliasConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionVersion").getter(AliasConfiguration.getter(AliasConfiguration::functionVersion)).setter(AliasConfiguration.setter(Builder::functionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AliasConfiguration.getter(AliasConfiguration::description)).setter(AliasConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AliasRoutingConfiguration> ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingConfig").getter(AliasConfiguration.getter(AliasConfiguration::routingConfig)).setter(AliasConfiguration.setter(Builder::routingConfig)).constructor(AliasRoutingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(AliasConfiguration.getter(AliasConfiguration::revisionId)).setter(AliasConfiguration.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ARN_FIELD, NAME_FIELD, FUNCTION_VERSION_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIG_FIELD, REVISION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aliasArn;
    private final String name;
    private final String functionVersion;
    private final String description;
    private final AliasRoutingConfiguration routingConfig;
    private final String revisionId;

    private AliasConfiguration(BuilderImpl builder) {
        this.aliasArn = builder.aliasArn;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
        this.revisionId = builder.revisionId;
    }

    public final String aliasArn() {
        return this.aliasArn;
    }

    public final String name() {
        return this.name;
    }

    public final String functionVersion() {
        return this.functionVersion;
    }

    public final String description() {
        return this.description;
    }

    public final AliasRoutingConfiguration routingConfig() {
        return this.routingConfig;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasConfiguration)) {
            return false;
        }
        AliasConfiguration other = (AliasConfiguration)obj;
        return Objects.equals(this.aliasArn(), other.aliasArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.functionVersion(), other.functionVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingConfig(), other.routingConfig()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"AliasConfiguration").add("AliasArn", (Object)this.aliasArn()).add("Name", (Object)this.name()).add("FunctionVersion", (Object)this.functionVersion()).add("Description", (Object)this.description()).add("RoutingConfig", (Object)this.routingConfig()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasArn": {
                return Optional.ofNullable(clazz.cast(this.aliasArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FunctionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasConfiguration, T> g) {
        return obj -> g.apply((AliasConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasArn;
        private String name;
        private String functionVersion;
        private String description;
        private AliasRoutingConfiguration routingConfig;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasConfiguration model) {
            this.aliasArn(model.aliasArn);
            this.name(model.name);
            this.functionVersion(model.functionVersion);
            this.description(model.description);
            this.routingConfig(model.routingConfig);
            this.revisionId(model.revisionId);
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        @Override
        @Transient
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        @Transient
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AliasRoutingConfiguration.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(AliasRoutingConfiguration.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder routingConfig(AliasRoutingConfiguration routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public AliasConfiguration build() {
            return new AliasConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AliasConfiguration> {
        public Builder aliasArn(String var1);

        public Builder name(String var1);

        public Builder functionVersion(String var1);

        public Builder description(String var1);

        public Builder routingConfig(AliasRoutingConfiguration var1);

        default public Builder routingConfig(Consumer<AliasRoutingConfiguration.Builder> routingConfig) {
            return this.routingConfig((AliasRoutingConfiguration)((AliasRoutingConfiguration.Builder)AliasRoutingConfiguration.builder().applyMutation(routingConfig)).build());
        }

        public Builder revisionId(String var1);
    }
}

