/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCodeSigningConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<DeleteCodeSigningConfigRequest.Builder, DeleteCodeSigningConfigRequest> {
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSigningConfigArn").getter(getter(DeleteCodeSigningConfigRequest::codeSigningConfigArn))
            .setter(setter(Builder::codeSigningConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CodeSigningConfigArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_ARN_FIELD));

    private final String codeSigningConfigArn;

    private DeleteCodeSigningConfigRequest(BuilderImpl builder) {
        super(builder);
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
    }

    /**
     * <p>
     * The The Amazon Resource Name (ARN) of the code signing configuration.
     * </p>
     * 
     * @return The The Amazon Resource Name (ARN) of the code signing configuration.
     */
    public final String codeSigningConfigArn() {
        return codeSigningConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningConfigArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCodeSigningConfigRequest)) {
            return false;
        }
        DeleteCodeSigningConfigRequest other = (DeleteCodeSigningConfigRequest) obj;
        return Objects.equals(codeSigningConfigArn(), other.codeSigningConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCodeSigningConfigRequest").add("CodeSigningConfigArn", codeSigningConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeSigningConfigArn":
            return Optional.ofNullable(clazz.cast(codeSigningConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCodeSigningConfigRequest, T> g) {
        return obj -> g.apply((DeleteCodeSigningConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCodeSigningConfigRequest> {
        /**
         * <p>
         * The The Amazon Resource Name (ARN) of the code signing configuration.
         * </p>
         * 
         * @param codeSigningConfigArn
         *        The The Amazon Resource Name (ARN) of the code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigArn(String codeSigningConfigArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String codeSigningConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCodeSigningConfigRequest model) {
            super(model);
            codeSigningConfigArn(model.codeSigningConfigArn);
        }

        public final String getCodeSigningConfigArn() {
            return codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        @Transient
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCodeSigningConfigRequest build() {
            return new DeleteCodeSigningConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
