/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListCopier;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisionedConcurrencyConfigsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListProvisionedConcurrencyConfigsResponse> {
    private static final SdkField<List<ProvisionedConcurrencyConfigListItem>> PROVISIONED_CONCURRENCY_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionedConcurrencyConfigs").getter(ListProvisionedConcurrencyConfigsResponse.getter(ListProvisionedConcurrencyConfigsResponse::provisionedConcurrencyConfigs)).setter(ListProvisionedConcurrencyConfigsResponse.setter(Builder::provisionedConcurrencyConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedConcurrencyConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisionedConcurrencyConfigListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListProvisionedConcurrencyConfigsResponse.getter(ListProvisionedConcurrencyConfigsResponse::nextMarker)).setter(ListProvisionedConcurrencyConfigsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_CONCURRENCY_CONFIGS_FIELD, NEXT_MARKER_FIELD));
    private final List<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs;
    private final String nextMarker;

    private ListProvisionedConcurrencyConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedConcurrencyConfigs = builder.provisionedConcurrencyConfigs;
        this.nextMarker = builder.nextMarker;
    }

    public boolean hasProvisionedConcurrencyConfigs() {
        return this.provisionedConcurrencyConfigs != null && !(this.provisionedConcurrencyConfigs instanceof SdkAutoConstructList);
    }

    public List<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs() {
        return this.provisionedConcurrencyConfigs;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedConcurrencyConfigs() ? this.provisionedConcurrencyConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedConcurrencyConfigsResponse)) {
            return false;
        }
        ListProvisionedConcurrencyConfigsResponse other = (ListProvisionedConcurrencyConfigsResponse)((Object)obj);
        return this.hasProvisionedConcurrencyConfigs() == other.hasProvisionedConcurrencyConfigs() && Objects.equals(this.provisionedConcurrencyConfigs(), other.provisionedConcurrencyConfigs()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListProvisionedConcurrencyConfigsResponse").add("ProvisionedConcurrencyConfigs", this.hasProvisionedConcurrencyConfigs() ? this.provisionedConcurrencyConfigs() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedConcurrencyConfigs": {
                return Optional.ofNullable(clazz.cast(this.provisionedConcurrencyConfigs()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedConcurrencyConfigsResponse, T> g) {
        return obj -> g.apply((ListProvisionedConcurrencyConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedConcurrencyConfigsResponse model) {
            super(model);
            this.provisionedConcurrencyConfigs(model.provisionedConcurrencyConfigs);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<ProvisionedConcurrencyConfigListItem.Builder> getProvisionedConcurrencyConfigs() {
            if (this.provisionedConcurrencyConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.provisionedConcurrencyConfigs != null ? (Collection)this.provisionedConcurrencyConfigs.stream().map(ProvisionedConcurrencyConfigListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedConcurrencyConfigs(Collection<ProvisionedConcurrencyConfigListItem> provisionedConcurrencyConfigs) {
            this.provisionedConcurrencyConfigs = ProvisionedConcurrencyConfigListCopier.copy(provisionedConcurrencyConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedConcurrencyConfigs(ProvisionedConcurrencyConfigListItem ... provisionedConcurrencyConfigs) {
            this.provisionedConcurrencyConfigs(Arrays.asList(provisionedConcurrencyConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedConcurrencyConfigs(Consumer<ProvisionedConcurrencyConfigListItem.Builder> ... provisionedConcurrencyConfigs) {
            this.provisionedConcurrencyConfigs(Stream.of(provisionedConcurrencyConfigs).map(c -> (ProvisionedConcurrencyConfigListItem)((ProvisionedConcurrencyConfigListItem.Builder)ProvisionedConcurrencyConfigListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedConcurrencyConfigs(Collection<ProvisionedConcurrencyConfigListItem.BuilderImpl> provisionedConcurrencyConfigs) {
            this.provisionedConcurrencyConfigs = ProvisionedConcurrencyConfigListCopier.copyFromBuilder(provisionedConcurrencyConfigs);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListProvisionedConcurrencyConfigsResponse build() {
            return new ListProvisionedConcurrencyConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisionedConcurrencyConfigsResponse> {
        public Builder provisionedConcurrencyConfigs(Collection<ProvisionedConcurrencyConfigListItem> var1);

        public Builder provisionedConcurrencyConfigs(ProvisionedConcurrencyConfigListItem ... var1);

        public Builder provisionedConcurrencyConfigs(Consumer<ProvisionedConcurrencyConfigListItem.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

