/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.CompatibleRuntimesCopier;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LayerVersionContentInput;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishLayerVersionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PublishLayerVersionRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionRequest.getter(PublishLayerVersionRequest::layerName)).setter(PublishLayerVersionRequest.setter(Builder::layerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionRequest.getter(PublishLayerVersionRequest::description)).setter(PublishLayerVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<LayerVersionContentInput> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PublishLayerVersionRequest.getter(PublishLayerVersionRequest::content)).setter(PublishLayerVersionRequest.setter(Builder::content)).constructor(LayerVersionContentInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PublishLayerVersionRequest.getter(PublishLayerVersionRequest::compatibleRuntimesAsStrings)).setter(PublishLayerVersionRequest.setter(Builder::compatibleRuntimesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishLayerVersionRequest.getter(PublishLayerVersionRequest::licenseInfo)).setter(PublishLayerVersionRequest.setter(Builder::licenseInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD, DESCRIPTION_FIELD, CONTENT_FIELD, COMPATIBLE_RUNTIMES_FIELD, LICENSE_INFO_FIELD));
    private final String layerName;
    private final String description;
    private final LayerVersionContentInput content;
    private final List<String> compatibleRuntimes;
    private final String licenseInfo;

    private PublishLayerVersionRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.description = builder.description;
        this.content = builder.content;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.licenseInfo = builder.licenseInfo;
    }

    public String layerName() {
        return this.layerName;
    }

    public String description() {
        return this.description;
    }

    public LayerVersionContentInput content() {
        return this.content;
    }

    public List<Runtime> compatibleRuntimes() {
        return CompatibleRuntimesCopier.copyStringToEnum(this.compatibleRuntimes);
    }

    public boolean hasCompatibleRuntimes() {
        return this.compatibleRuntimes != null && !(this.compatibleRuntimes instanceof SdkAutoConstructList);
    }

    public List<String> compatibleRuntimesAsStrings() {
        return this.compatibleRuntimes;
    }

    public String licenseInfo() {
        return this.licenseInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleRuntimesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishLayerVersionRequest)) {
            return false;
        }
        PublishLayerVersionRequest other = (PublishLayerVersionRequest)((Object)obj);
        return Objects.equals(this.layerName(), other.layerName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.compatibleRuntimesAsStrings(), other.compatibleRuntimesAsStrings()) && Objects.equals(this.licenseInfo(), other.licenseInfo());
    }

    public String toString() {
        return ToString.builder((String)"PublishLayerVersionRequest").add("LayerName", (Object)this.layerName()).add("Description", (Object)this.description()).add("Content", (Object)this.content()).add("CompatibleRuntimes", this.compatibleRuntimesAsStrings()).add("LicenseInfo", (Object)this.licenseInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerName": {
                return Optional.ofNullable(clazz.cast(this.layerName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "CompatibleRuntimes": {
                return Optional.ofNullable(clazz.cast(this.compatibleRuntimesAsStrings()));
            }
            case "LicenseInfo": {
                return Optional.ofNullable(clazz.cast(this.licenseInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishLayerVersionRequest, T> g) {
        return obj -> g.apply((PublishLayerVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String layerName;
        private String description;
        private LayerVersionContentInput content;
        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();
        private String licenseInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishLayerVersionRequest model) {
            super(model);
            this.layerName(model.layerName);
            this.description(model.description);
            this.content(model.content);
            this.compatibleRuntimesWithStrings(model.compatibleRuntimes);
            this.licenseInfo(model.licenseInfo);
        }

        public final String getLayerName() {
            return this.layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final LayerVersionContentInput.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        @Override
        public final Builder content(LayerVersionContentInput content) {
            this.content = content;
            return this;
        }

        public final void setContent(LayerVersionContentInput.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final Collection<String> getCompatibleRuntimes() {
            return this.compatibleRuntimes;
        }

        @Override
        public final Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimesWithStrings(String ... compatibleRuntimes) {
            this.compatibleRuntimesWithStrings(Arrays.asList(compatibleRuntimes));
            return this;
        }

        @Override
        public final Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copyEnumToString(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(Runtime ... compatibleRuntimes) {
            this.compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
        }

        public final String getLicenseInfo() {
            return this.licenseInfo;
        }

        @Override
        public final Builder licenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        public final void setLicenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishLayerVersionRequest build() {
            return new PublishLayerVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishLayerVersionRequest> {
        public Builder layerName(String var1);

        public Builder description(String var1);

        public Builder content(LayerVersionContentInput var1);

        default public Builder content(Consumer<LayerVersionContentInput.Builder> content) {
            return this.content((LayerVersionContentInput)((LayerVersionContentInput.Builder)LayerVersionContentInput.builder().applyMutation(content)).build());
        }

        public Builder compatibleRuntimesWithStrings(Collection<String> var1);

        public Builder compatibleRuntimesWithStrings(String ... var1);

        public Builder compatibleRuntimes(Collection<Runtime> var1);

        public Builder compatibleRuntimes(Runtime ... var1);

        public Builder licenseInfo(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

