/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StateReasonCode {
    IDLE("Idle"),
    CREATING("Creating"),
    RESTORING("Restoring"),
    ENI_LIMIT_EXCEEDED("EniLimitExceeded"),
    INSUFFICIENT_ROLE_PERMISSIONS("InsufficientRolePermissions"),
    INVALID_CONFIGURATION("InvalidConfiguration"),
    INTERNAL_ERROR("InternalError"),
    SUBNET_OUT_OF_IP_ADDRESSES("SubnetOutOfIPAddresses"),
    INVALID_SUBNET("InvalidSubnet"),
    INVALID_SECURITY_GROUP("InvalidSecurityGroup"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StateReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StateReasonCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateReasonCode> knownValues() {
        return Stream.of(StateReasonCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

