/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFunctionCodeRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, UpdateFunctionCodeRequest> {
    private final String functionName;
    private final ByteBuffer zipFile;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;
    private final Boolean publish;
    private final Boolean dryRun;

    private UpdateFunctionCodeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.publish = builder.publish;
        this.dryRun = builder.dryRun;
    }

    public String functionName() {
        return this.functionName;
    }

    public ByteBuffer zipFile() {
        return this.zipFile == null ? null : this.zipFile.asReadOnlyBuffer();
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public Boolean publish() {
        return this.publish;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.publish());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionCodeRequest)) {
            return false;
        }
        UpdateFunctionCodeRequest other = (UpdateFunctionCodeRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.zipFile(), other.zipFile()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3ObjectVersion(), other.s3ObjectVersion()) && Objects.equals(this.publish(), other.publish()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFunctionCodeRequest").add("FunctionName", (Object)this.functionName()).add("ZipFile", (Object)this.zipFile()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3ObjectVersion", (Object)this.s3ObjectVersion()).add("Publish", (Object)this.publish()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "ZipFile": {
                return Optional.of(clazz.cast(this.zipFile()));
            }
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.of(clazz.cast(this.s3Key()));
            }
            case "S3ObjectVersion": {
                return Optional.of(clazz.cast(this.s3ObjectVersion()));
            }
            case "Publish": {
                return Optional.of(clazz.cast(this.publish()));
            }
            case "DryRun": {
                return Optional.of(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private ByteBuffer zipFile;
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;
        private Boolean publish;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionCodeRequest model) {
            this.functionName(model.functionName);
            this.zipFile(model.zipFile);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3ObjectVersion(model.s3ObjectVersion);
            this.publish(model.publish);
            this.dryRun(model.dryRun);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile;
        }

        @Override
        public final Builder zipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        public final Boolean getPublish() {
            return this.publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionCodeRequest build() {
            return new UpdateFunctionCodeRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, UpdateFunctionCodeRequest> {
        public Builder functionName(String var1);

        public Builder zipFile(ByteBuffer var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);

        public Builder publish(Boolean var1);

        public Builder dryRun(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

