/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAliasResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UpdateAliasResponse> {
    private final String aliasArn;
    private final String name;
    private final String functionVersion;
    private final String description;

    private UpdateAliasResponse(BuilderImpl builder) {
        this.aliasArn = builder.aliasArn;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
    }

    public String aliasArn() {
        return this.aliasArn;
    }

    public String name() {
        return this.name;
    }

    public String functionVersion() {
        return this.functionVersion;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aliasArn() == null ? 0 : this.aliasArn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.functionVersion() == null ? 0 : this.functionVersion().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAliasResponse)) {
            return false;
        }
        UpdateAliasResponse other = (UpdateAliasResponse)((Object)obj);
        if (other.aliasArn() == null ^ this.aliasArn() == null) {
            return false;
        }
        if (other.aliasArn() != null && !other.aliasArn().equals(this.aliasArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.functionVersion() == null ^ this.functionVersion() == null) {
            return false;
        }
        if (other.functionVersion() != null && !other.functionVersion().equals(this.functionVersion())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.aliasArn() != null) {
            sb.append("AliasArn: ").append(this.aliasArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.functionVersion() != null) {
            sb.append("FunctionVersion: ").append(this.functionVersion()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasArn": {
                return Optional.of(clazz.cast(this.aliasArn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "FunctionVersion": {
                return Optional.of(clazz.cast(this.functionVersion()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasArn;
        private String name;
        private String functionVersion;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAliasResponse model) {
            this.aliasArn(model.aliasArn);
            this.name(model.name);
            this.functionVersion(model.functionVersion);
            this.description(model.description);
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public UpdateAliasResponse build() {
            return new UpdateAliasResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateAliasResponse> {
        public Builder aliasArn(String var1);

        public Builder name(String var1);

        public Builder functionVersion(String var1);

        public Builder description(String var1);
    }
}

