/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.FunctionCode;

@SdkInternalApi
public class FunctionCodeMarshaller {
    private static final MarshallingInfo<ByteBuffer> ZIPFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipFile").build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Key").build();
    private static final MarshallingInfo<String> S3OBJECTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ObjectVersion").build();
    private static final FunctionCodeMarshaller INSTANCE = new FunctionCodeMarshaller();

    public static FunctionCodeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionCode functionCode, ProtocolMarshaller protocolMarshaller) {
        if (functionCode == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)functionCode.zipFile(), ZIPFILE_BINDING);
            protocolMarshaller.marshall((Object)functionCode.s3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)functionCode.s3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall((Object)functionCode.s3ObjectVersion(), S3OBJECTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

