/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.AliasConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AliasConfigurationMarshaller {
    private static final MarshallingInfo<String> ALIASARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionVersion").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ROUTINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingConfig").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevisionId").isBinary(false).build();
    private static final AliasConfigurationMarshaller INSTANCE = new AliasConfigurationMarshaller();

    private AliasConfigurationMarshaller() {
    }

    public static AliasConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AliasConfiguration aliasConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aliasConfiguration, (String)"aliasConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aliasConfiguration.aliasArn(), ALIASARN_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.functionVersion(), FUNCTIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.routingConfig(), ROUTINGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.revisionId(), REVISIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

