/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.TracingMode;
import software.amazon.awssdk.services.lambda.transform.TracingConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TracingConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, TracingConfig> {
    private final String mode;

    private TracingConfig(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    public TracingMode mode() {
        return TracingMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracingConfig)) {
            return false;
        }
        TracingConfig other = (TracingConfig)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TracingConfig").add("Mode", (Object)this.modeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TracingConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(TracingConfig model) {
            this.mode(model.mode);
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(TracingMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public TracingConfig build() {
            return new TracingConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TracingConfig> {
        public Builder mode(String var1);

        public Builder mode(TracingMode var1);
    }
}

