/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.AccountUsageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountUsage> {
    private final Long totalCodeSize;
    private final Long functionCount;

    private AccountUsage(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.functionCount = builder.functionCount;
    }

    public Long totalCodeSize() {
        return this.totalCodeSize;
    }

    public Long functionCount() {
        return this.functionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCodeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountUsage)) {
            return false;
        }
        AccountUsage other = (AccountUsage)obj;
        return Objects.equals(this.totalCodeSize(), other.totalCodeSize()) && Objects.equals(this.functionCount(), other.functionCount());
    }

    public String toString() {
        return ToString.builder((String)"AccountUsage").add("TotalCodeSize", (Object)this.totalCodeSize()).add("FunctionCount", (Object)this.functionCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCodeSize": {
                return Optional.ofNullable(clazz.cast(this.totalCodeSize()));
            }
            case "FunctionCount": {
                return Optional.ofNullable(clazz.cast(this.functionCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalCodeSize;
        private Long functionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountUsage model) {
            this.totalCodeSize(model.totalCodeSize);
            this.functionCount(model.functionCount);
        }

        public final Long getTotalCodeSize() {
            return this.totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        public final Long getFunctionCount() {
            return this.functionCount;
        }

        @Override
        public final Builder functionCount(Long functionCount) {
            this.functionCount = functionCount;
            return this;
        }

        public final void setFunctionCount(Long functionCount) {
            this.functionCount = functionCount;
        }

        public AccountUsage build() {
            return new AccountUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountUsage> {
        public Builder totalCodeSize(Long var1);

        public Builder functionCount(Long var1);
    }
}

