/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ThrottleReason;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TooManyRequestsException
extends LambdaException
implements ToCopyableBuilder<Builder, TooManyRequestsException> {
    private final String retryAfterSeconds;
    private final String type;
    private final String reason;

    private TooManyRequestsException(BuilderImpl builder) {
        super(builder);
        this.retryAfterSeconds = builder.retryAfterSeconds;
        this.type = builder.type;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String retryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public String type() {
        return this.type;
    }

    public ThrottleReason reason() {
        return ThrottleReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    static final class BuilderImpl
    extends LambdaException.BuilderImpl
    implements Builder {
        private String retryAfterSeconds;
        private String type;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(TooManyRequestsException model) {
            super(model);
            this.retryAfterSeconds(model.retryAfterSeconds);
            this.type(model.type);
            this.reason(model.reason);
        }

        public final String getRetryAfterSeconds() {
            return this.retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @JsonProperty(value="Retry-After")
        public final void setRetryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="Type")
        public final void setType(String type) {
            this.type = type;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ThrottleReason reason) {
            this.reason(reason.toString());
            return this;
        }

        @JsonProperty(value="Reason")
        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public TooManyRequestsException build() {
            return new TooManyRequestsException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TooManyRequestsException>,
    LambdaException.Builder {
        public Builder retryAfterSeconds(String var1);

        public Builder type(String var1);

        public Builder reason(String var1);

        public Builder reason(ThrottleReason var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

