/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.FunctionCodeLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FunctionCodeLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionCodeLocation> {
    private final String repositoryType;
    private final String location;

    private FunctionCodeLocation(BuilderImpl builder) {
        this.repositoryType = builder.repositoryType;
        this.location = builder.location;
    }

    public String repositoryType() {
        return this.repositoryType;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.repositoryType() == null ? 0 : this.repositoryType().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCodeLocation)) {
            return false;
        }
        FunctionCodeLocation other = (FunctionCodeLocation)obj;
        if (other.repositoryType() == null ^ this.repositoryType() == null) {
            return false;
        }
        if (other.repositoryType() != null && !other.repositoryType().equals(this.repositoryType())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        return other.location() == null || other.location().equals(this.location());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.repositoryType() != null) {
            sb.append("RepositoryType: ").append(this.repositoryType()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionCodeLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String repositoryType;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCodeLocation model) {
            this.setRepositoryType(model.repositoryType);
            this.setLocation(model.location);
        }

        public final String getRepositoryType() {
            return this.repositoryType;
        }

        @Override
        public final Builder repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public final void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public FunctionCodeLocation build() {
            return new FunctionCodeLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionCodeLocation> {
        public Builder repositoryType(String var1);

        public Builder location(String var1);
    }
}

