/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lambda.transform.FunctionCodeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FunctionCode
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionCode> {
    private final ByteBuffer zipFile;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;

    private FunctionCode(BuilderImpl builder) {
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
    }

    public ByteBuffer zipFile() {
        return this.zipFile;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.zipFile() == null ? 0 : this.zipFile().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Key() == null ? 0 : this.s3Key().hashCode());
        hashCode = 31 * hashCode + (this.s3ObjectVersion() == null ? 0 : this.s3ObjectVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCode)) {
            return false;
        }
        FunctionCode other = (FunctionCode)obj;
        if (other.zipFile() == null ^ this.zipFile() == null) {
            return false;
        }
        if (other.zipFile() != null && !other.zipFile().equals(this.zipFile())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Key() == null ^ this.s3Key() == null) {
            return false;
        }
        if (other.s3Key() != null && !other.s3Key().equals(this.s3Key())) {
            return false;
        }
        if (other.s3ObjectVersion() == null ^ this.s3ObjectVersion() == null) {
            return false;
        }
        return other.s3ObjectVersion() == null || other.s3ObjectVersion().equals(this.s3ObjectVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.zipFile() != null) {
            sb.append("ZipFile: ").append(this.zipFile()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Key() != null) {
            sb.append("S3Key: ").append(this.s3Key()).append(",");
        }
        if (this.s3ObjectVersion() != null) {
            sb.append("S3ObjectVersion: ").append(this.s3ObjectVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionCodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer zipFile;
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCode model) {
            this.setZipFile(model.zipFile);
            this.setS3Bucket(model.s3Bucket);
            this.setS3Key(model.s3Key);
            this.setS3ObjectVersion(model.s3ObjectVersion);
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile;
        }

        @Override
        public final Builder zipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        public FunctionCode build() {
            return new FunctionCode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionCode> {
        public Builder zipFile(ByteBuffer var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);
    }
}

