/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.AliasListEntry;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;

public class ListAliasesPublisher
implements SdkPublisher<ListAliasesResponse> {
    private final KmsAsyncClient client;
    private final ListAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAliasesPublisher(KmsAsyncClient client, ListAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAliasesPublisher(KmsAsyncClient client, ListAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AliasListEntry> aliases() {
        return this.flatMapIterable(response -> response.aliases());
    }

    private class ListAliasesResponseFetcher
    implements AsyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return previousPage.truncated() != null && previousPage.truncated() != false;
        }

        public CompletableFuture<ListAliasesResponse> nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesPublisher.this.client.listAliases(ListAliasesPublisher.this.firstRequest);
            }
            return ListAliasesPublisher.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

