/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReEncryptResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ReEncryptResponse> {
    private static final SdkField<SdkBytes> CIPHERTEXT_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextBlob").getter(ReEncryptResponse.getter(ReEncryptResponse::ciphertextBlob)).setter(ReEncryptResponse.setter(Builder::ciphertextBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextBlob").build()}).build();
    private static final SdkField<String> SOURCE_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceKeyId").getter(ReEncryptResponse.getter(ReEncryptResponse::sourceKeyId)).setter(ReEncryptResponse.setter(Builder::sourceKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceKeyId").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(ReEncryptResponse.getter(ReEncryptResponse::keyId)).setter(ReEncryptResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> SOURCE_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEncryptionAlgorithm").getter(ReEncryptResponse.getter(ReEncryptResponse::sourceEncryptionAlgorithmAsString)).setter(ReEncryptResponse.setter(Builder::sourceEncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEncryptionAlgorithm").build()}).build();
    private static final SdkField<String> DESTINATION_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationEncryptionAlgorithm").getter(ReEncryptResponse.getter(ReEncryptResponse::destinationEncryptionAlgorithmAsString)).setter(ReEncryptResponse.setter(Builder::destinationEncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEncryptionAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHERTEXT_BLOB_FIELD, SOURCE_KEY_ID_FIELD, KEY_ID_FIELD, SOURCE_ENCRYPTION_ALGORITHM_FIELD, DESTINATION_ENCRYPTION_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReEncryptResponse.memberNameToFieldInitializer();
    private final SdkBytes ciphertextBlob;
    private final String sourceKeyId;
    private final String keyId;
    private final String sourceEncryptionAlgorithm;
    private final String destinationEncryptionAlgorithm;

    private ReEncryptResponse(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceKeyId = builder.sourceKeyId;
        this.keyId = builder.keyId;
        this.sourceEncryptionAlgorithm = builder.sourceEncryptionAlgorithm;
        this.destinationEncryptionAlgorithm = builder.destinationEncryptionAlgorithm;
    }

    public final SdkBytes ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public final String sourceKeyId() {
        return this.sourceKeyId;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final EncryptionAlgorithmSpec sourceEncryptionAlgorithm() {
        return EncryptionAlgorithmSpec.fromValue(this.sourceEncryptionAlgorithm);
    }

    public final String sourceEncryptionAlgorithmAsString() {
        return this.sourceEncryptionAlgorithm;
    }

    public final EncryptionAlgorithmSpec destinationEncryptionAlgorithm() {
        return EncryptionAlgorithmSpec.fromValue(this.destinationEncryptionAlgorithm);
    }

    public final String destinationEncryptionAlgorithmAsString() {
        return this.destinationEncryptionAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEncryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEncryptionAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptResponse)) {
            return false;
        }
        ReEncryptResponse other = (ReEncryptResponse)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.sourceKeyId(), other.sourceKeyId()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.sourceEncryptionAlgorithmAsString(), other.sourceEncryptionAlgorithmAsString()) && Objects.equals(this.destinationEncryptionAlgorithmAsString(), other.destinationEncryptionAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReEncryptResponse").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("SourceKeyId", (Object)this.sourceKeyId()).add("KeyId", (Object)this.keyId()).add("SourceEncryptionAlgorithm", (Object)this.sourceEncryptionAlgorithmAsString()).add("DestinationEncryptionAlgorithm", (Object)this.destinationEncryptionAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.ciphertextBlob()));
            }
            case "SourceKeyId": {
                return Optional.ofNullable(clazz.cast(this.sourceKeyId()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "SourceEncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.sourceEncryptionAlgorithmAsString()));
            }
            case "DestinationEncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.destinationEncryptionAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CiphertextBlob", CIPHERTEXT_BLOB_FIELD);
        map.put("SourceKeyId", SOURCE_KEY_ID_FIELD);
        map.put("KeyId", KEY_ID_FIELD);
        map.put("SourceEncryptionAlgorithm", SOURCE_ENCRYPTION_ALGORITHM_FIELD);
        map.put("DestinationEncryptionAlgorithm", DESTINATION_ENCRYPTION_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReEncryptResponse, T> g) {
        return obj -> g.apply((ReEncryptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes ciphertextBlob;
        private String sourceKeyId;
        private String keyId;
        private String sourceEncryptionAlgorithm;
        private String destinationEncryptionAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptResponse model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.sourceKeyId(model.sourceKeyId);
            this.keyId(model.keyId);
            this.sourceEncryptionAlgorithm(model.sourceEncryptionAlgorithm);
            this.destinationEncryptionAlgorithm(model.destinationEncryptionAlgorithm);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob == null ? null : this.ciphertextBlob.asByteBuffer();
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob(ciphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextBlob));
        }

        @Override
        public final Builder ciphertextBlob(SdkBytes ciphertextBlob) {
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public final String getSourceKeyId() {
            return this.sourceKeyId;
        }

        public final void setSourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
        }

        @Override
        public final Builder sourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getSourceEncryptionAlgorithm() {
            return this.sourceEncryptionAlgorithm;
        }

        public final void setSourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
            this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
        }

        @Override
        public final Builder sourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
            this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder sourceEncryptionAlgorithm(EncryptionAlgorithmSpec sourceEncryptionAlgorithm) {
            this.sourceEncryptionAlgorithm(sourceEncryptionAlgorithm == null ? null : sourceEncryptionAlgorithm.toString());
            return this;
        }

        public final String getDestinationEncryptionAlgorithm() {
            return this.destinationEncryptionAlgorithm;
        }

        public final void setDestinationEncryptionAlgorithm(String destinationEncryptionAlgorithm) {
            this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm;
        }

        @Override
        public final Builder destinationEncryptionAlgorithm(String destinationEncryptionAlgorithm) {
            this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder destinationEncryptionAlgorithm(EncryptionAlgorithmSpec destinationEncryptionAlgorithm) {
            this.destinationEncryptionAlgorithm(destinationEncryptionAlgorithm == null ? null : destinationEncryptionAlgorithm.toString());
            return this;
        }

        @Override
        public ReEncryptResponse build() {
            return new ReEncryptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReEncryptResponse> {
        public Builder ciphertextBlob(SdkBytes var1);

        public Builder sourceKeyId(String var1);

        public Builder keyId(String var1);

        public Builder sourceEncryptionAlgorithm(String var1);

        public Builder sourceEncryptionAlgorithm(EncryptionAlgorithmSpec var1);

        public Builder destinationEncryptionAlgorithm(String var1);

        public Builder destinationEncryptionAlgorithm(EncryptionAlgorithmSpec var1);
    }
}

