/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.RecipientInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateDataKeyRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, GenerateDataKeyRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::keyId)).setter(GenerateDataKeyRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EncryptionContext").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::encryptionContext)).setter(GenerateDataKeyRequest.setter(Builder::encryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBytes").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::numberOfBytes)).setter(GenerateDataKeyRequest.setter(Builder::numberOfBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBytes").build()}).build();
    private static final SdkField<String> KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeySpec").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::keySpecAsString)).setter(GenerateDataKeyRequest.setter(Builder::keySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySpec").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::grantTokens)).setter(GenerateDataKeyRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecipientInfo> RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recipient").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::recipient)).setter(GenerateDataKeyRequest.setter(Builder::recipient)).constructor(RecipientInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipient").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(GenerateDataKeyRequest.getter(GenerateDataKeyRequest::dryRun)).setter(GenerateDataKeyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, ENCRYPTION_CONTEXT_FIELD, NUMBER_OF_BYTES_FIELD, KEY_SPEC_FIELD, GRANT_TOKENS_FIELD, RECIPIENT_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GenerateDataKeyRequest.memberNameToFieldInitializer();
    private final String keyId;
    private final Map<String, String> encryptionContext;
    private final Integer numberOfBytes;
    private final String keySpec;
    private final List<String> grantTokens;
    private final RecipientInfo recipient;
    private final Boolean dryRun;

    private GenerateDataKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.encryptionContext = builder.encryptionContext;
        this.numberOfBytes = builder.numberOfBytes;
        this.keySpec = builder.keySpec;
        this.grantTokens = builder.grantTokens;
        this.recipient = builder.recipient;
        this.dryRun = builder.dryRun;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final boolean hasEncryptionContext() {
        return this.encryptionContext != null && !(this.encryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public final Integer numberOfBytes() {
        return this.numberOfBytes;
    }

    public final DataKeySpec keySpec() {
        return DataKeySpec.fromValue(this.keySpec);
    }

    public final String keySpecAsString() {
        return this.keySpec;
    }

    public final boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public final List<String> grantTokens() {
        return this.grantTokens;
    }

    public final RecipientInfo recipient() {
        return this.recipient;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionContext() ? this.encryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyRequest)) {
            return false;
        }
        GenerateDataKeyRequest other = (GenerateDataKeyRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && this.hasEncryptionContext() == other.hasEncryptionContext() && Objects.equals(this.encryptionContext(), other.encryptionContext()) && Objects.equals(this.numberOfBytes(), other.numberOfBytes()) && Objects.equals(this.keySpecAsString(), other.keySpecAsString()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.recipient(), other.recipient()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateDataKeyRequest").add("KeyId", (Object)this.keyId()).add("EncryptionContext", this.hasEncryptionContext() ? this.encryptionContext() : null).add("NumberOfBytes", (Object)this.numberOfBytes()).add("KeySpec", (Object)this.keySpecAsString()).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("Recipient", (Object)this.recipient()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "EncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.encryptionContext()));
            }
            case "NumberOfBytes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBytes()));
            }
            case "KeySpec": {
                return Optional.ofNullable(clazz.cast(this.keySpecAsString()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "Recipient": {
                return Optional.ofNullable(clazz.cast(this.recipient()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("EncryptionContext", ENCRYPTION_CONTEXT_FIELD);
        map.put("NumberOfBytes", NUMBER_OF_BYTES_FIELD);
        map.put("KeySpec", KEY_SPEC_FIELD);
        map.put("GrantTokens", GRANT_TOKENS_FIELD);
        map.put("Recipient", RECIPIENT_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateDataKeyRequest, T> g) {
        return obj -> g.apply((GenerateDataKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private Map<String, String> encryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private Integer numberOfBytes;
        private String keySpec;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private RecipientInfo recipient;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.encryptionContext(model.encryptionContext);
            this.numberOfBytes(model.numberOfBytes);
            this.keySpec(model.keySpec);
            this.grantTokens(model.grantTokens);
            this.recipient(model.recipient);
            this.dryRun(model.dryRun);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Map<String, String> getEncryptionContext() {
            if (this.encryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.encryptionContext;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final Integer getNumberOfBytes() {
            return this.numberOfBytes;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final String getKeySpec() {
            return this.keySpec;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(DataKeySpec keySpec) {
            this.keySpec(keySpec == null ? null : keySpec.toString());
            return this;
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final RecipientInfo.Builder getRecipient() {
            return this.recipient != null ? this.recipient.toBuilder() : null;
        }

        public final void setRecipient(RecipientInfo.BuilderImpl recipient) {
            this.recipient = recipient != null ? recipient.build() : null;
        }

        @Override
        public final Builder recipient(RecipientInfo recipient) {
            this.recipient = recipient;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataKeyRequest build() {
            return new GenerateDataKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateDataKeyRequest> {
        public Builder keyId(String var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder numberOfBytes(Integer var1);

        public Builder keySpec(String var1);

        public Builder keySpec(DataKeySpec var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder recipient(RecipientInfo var1);

        default public Builder recipient(Consumer<RecipientInfo.Builder> recipient) {
            return this.recipient((RecipientInfo)((RecipientInfo.Builder)RecipientInfo.builder().applyMutation(recipient)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

