/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsRequest;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsResponse;
import software.amazon.awssdk.services.kms.model.RotationsListEntry;

public class ListKeyRotationsIterable
implements SdkIterable<ListKeyRotationsResponse> {
    private final KmsClient client;
    private final ListKeyRotationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeyRotationsIterable(KmsClient client, ListKeyRotationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKeyRotationsResponseFetcher();
    }

    public Iterator<ListKeyRotationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RotationsListEntry> rotations() {
        Function<ListKeyRotationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotations() != null) {
                return response.rotations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKeyRotationsResponseFetcher
    implements SyncPageFetcher<ListKeyRotationsResponse> {
        private ListKeyRotationsResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyRotationsResponse previousPage) {
            return previousPage.truncated();
        }

        public ListKeyRotationsResponse nextPage(ListKeyRotationsResponse previousPage) {
            if (previousPage == null) {
                return ListKeyRotationsIterable.this.client.listKeyRotations(ListKeyRotationsIterable.this.firstRequest);
            }
            return ListKeyRotationsIterable.this.client.listKeyRotations((ListKeyRotationsRequest)((Object)ListKeyRotationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

