/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.AlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.WrappingKeySpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersForImportRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, GetParametersForImportRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GetParametersForImportRequest.getter(GetParametersForImportRequest::keyId)).setter(GetParametersForImportRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> WRAPPING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingAlgorithm").getter(GetParametersForImportRequest.getter(GetParametersForImportRequest::wrappingAlgorithmAsString)).setter(GetParametersForImportRequest.setter(Builder::wrappingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingAlgorithm").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeySpec").getter(GetParametersForImportRequest.getter(GetParametersForImportRequest::wrappingKeySpecAsString)).setter(GetParametersForImportRequest.setter(Builder::wrappingKeySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeySpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, WRAPPING_ALGORITHM_FIELD, WRAPPING_KEY_SPEC_FIELD));
    private final String keyId;
    private final String wrappingAlgorithm;
    private final String wrappingKeySpec;

    private GetParametersForImportRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final AlgorithmSpec wrappingAlgorithm() {
        return AlgorithmSpec.fromValue(this.wrappingAlgorithm);
    }

    public final String wrappingAlgorithmAsString() {
        return this.wrappingAlgorithm;
    }

    public final WrappingKeySpec wrappingKeySpec() {
        return WrappingKeySpec.fromValue(this.wrappingKeySpec);
    }

    public final String wrappingKeySpecAsString() {
        return this.wrappingKeySpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeySpecAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.wrappingAlgorithmAsString(), other.wrappingAlgorithmAsString()) && Objects.equals(this.wrappingKeySpecAsString(), other.wrappingKeySpecAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetParametersForImportRequest").add("KeyId", (Object)this.keyId()).add("WrappingAlgorithm", (Object)this.wrappingAlgorithmAsString()).add("WrappingKeySpec", (Object)this.wrappingKeySpecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "WrappingAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.wrappingAlgorithmAsString()));
            }
            case "WrappingKeySpec": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeySpecAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForImportRequest, T> g) {
        return obj -> g.apply((GetParametersForImportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String wrappingAlgorithm;
        private String wrappingKeySpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.wrappingAlgorithm(model.wrappingAlgorithm);
            this.wrappingKeySpec(model.wrappingKeySpec);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getWrappingAlgorithm() {
            return this.wrappingAlgorithm;
        }

        public final void setWrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
        }

        @Override
        public final Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm == null ? null : wrappingAlgorithm.toString());
            return this;
        }

        public final String getWrappingKeySpec() {
            return this.wrappingKeySpec;
        }

        public final void setWrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
        }

        @Override
        public final Builder wrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        @Override
        public final Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec == null ? null : wrappingKeySpec.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParametersForImportRequest> {
        public Builder keyId(String var1);

        public Builder wrappingAlgorithm(String var1);

        public Builder wrappingAlgorithm(AlgorithmSpec var1);

        public Builder wrappingKeySpec(String var1);

        public Builder wrappingKeySpec(WrappingKeySpec var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

