/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse;

public class DescribeCustomKeyStoresPublisher
implements SdkPublisher<DescribeCustomKeyStoresResponse> {
    private final KmsAsyncClient client;
    private final DescribeCustomKeyStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCustomKeyStoresPublisher(KmsAsyncClient client, DescribeCustomKeyStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCustomKeyStoresPublisher(KmsAsyncClient client, DescribeCustomKeyStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCustomKeyStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCustomKeyStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomKeyStoresListEntry> customKeyStores() {
        Function<DescribeCustomKeyStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.customKeyStores() != null) {
                return response.customKeyStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCustomKeyStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCustomKeyStoresResponseFetcher
    implements AsyncPageFetcher<DescribeCustomKeyStoresResponse> {
        private DescribeCustomKeyStoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomKeyStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeCustomKeyStoresResponse> nextPage(DescribeCustomKeyStoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomKeyStoresPublisher.this.client.describeCustomKeyStores(DescribeCustomKeyStoresPublisher.this.firstRequest);
            }
            return DescribeCustomKeyStoresPublisher.this.client.describeCustomKeyStores((DescribeCustomKeyStoresRequest)((Object)DescribeCustomKeyStoresPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

