/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePrimaryRegionRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, UpdatePrimaryRegionRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(UpdatePrimaryRegionRequest.getter(UpdatePrimaryRegionRequest::keyId)).setter(UpdatePrimaryRegionRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryRegion").getter(UpdatePrimaryRegionRequest.getter(UpdatePrimaryRegionRequest::primaryRegion)).setter(UpdatePrimaryRegionRequest.setter(Builder::primaryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, PRIMARY_REGION_FIELD));
    private final String keyId;
    private final String primaryRegion;

    private UpdatePrimaryRegionRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.primaryRegion = builder.primaryRegion;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String primaryRegion() {
        return this.primaryRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePrimaryRegionRequest)) {
            return false;
        }
        UpdatePrimaryRegionRequest other = (UpdatePrimaryRegionRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.primaryRegion(), other.primaryRegion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePrimaryRegionRequest").add("KeyId", (Object)this.keyId()).add("PrimaryRegion", (Object)this.primaryRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "PrimaryRegion": {
                return Optional.ofNullable(clazz.cast(this.primaryRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePrimaryRegionRequest, T> g) {
        return obj -> g.apply((UpdatePrimaryRegionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String primaryRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePrimaryRegionRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.primaryRegion(model.primaryRegion);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        @Transient
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getPrimaryRegion() {
            return this.primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        @Transient
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePrimaryRegionRequest build() {
            return new UpdatePrimaryRegionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePrimaryRegionRequest> {
        public Builder keyId(String var1);

        public Builder primaryRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

