/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KeyState;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleKeyDeletionResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(ScheduleKeyDeletionResponse.getter(ScheduleKeyDeletionResponse::keyId)).setter(ScheduleKeyDeletionResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionDate").getter(ScheduleKeyDeletionResponse.getter(ScheduleKeyDeletionResponse::deletionDate)).setter(ScheduleKeyDeletionResponse.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final SdkField<String> KEY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyState").getter(ScheduleKeyDeletionResponse.getter(ScheduleKeyDeletionResponse::keyStateAsString)).setter(ScheduleKeyDeletionResponse.setter(Builder::keyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()}).build();
    private static final SdkField<Integer> PENDING_WINDOW_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PendingWindowInDays").getter(ScheduleKeyDeletionResponse.getter(ScheduleKeyDeletionResponse::pendingWindowInDays)).setter(ScheduleKeyDeletionResponse.setter(Builder::pendingWindowInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingWindowInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, DELETION_DATE_FIELD, KEY_STATE_FIELD, PENDING_WINDOW_IN_DAYS_FIELD));
    private final String keyId;
    private final Instant deletionDate;
    private final String keyState;
    private final Integer pendingWindowInDays;

    private ScheduleKeyDeletionResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.deletionDate = builder.deletionDate;
        this.keyState = builder.keyState;
        this.pendingWindowInDays = builder.pendingWindowInDays;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Instant deletionDate() {
        return this.deletionDate;
    }

    public final KeyState keyState() {
        return KeyState.fromValue(this.keyState);
    }

    public final String keyStateAsString() {
        return this.keyState;
    }

    public final Integer pendingWindowInDays() {
        return this.pendingWindowInDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingWindowInDays());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleKeyDeletionResponse)) {
            return false;
        }
        ScheduleKeyDeletionResponse other = (ScheduleKeyDeletionResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.keyStateAsString(), other.keyStateAsString()) && Objects.equals(this.pendingWindowInDays(), other.pendingWindowInDays());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleKeyDeletionResponse").add("KeyId", (Object)this.keyId()).add("DeletionDate", (Object)this.deletionDate()).add("KeyState", (Object)this.keyStateAsString()).add("PendingWindowInDays", (Object)this.pendingWindowInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
            case "KeyState": {
                return Optional.ofNullable(clazz.cast(this.keyStateAsString()));
            }
            case "PendingWindowInDays": {
                return Optional.ofNullable(clazz.cast(this.pendingWindowInDays()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleKeyDeletionResponse, T> g) {
        return obj -> g.apply((ScheduleKeyDeletionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private Instant deletionDate;
        private String keyState;
        private Integer pendingWindowInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleKeyDeletionResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.deletionDate(model.deletionDate);
            this.keyState(model.keyState);
            this.pendingWindowInDays(model.pendingWindowInDays);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final String getKeyState() {
            return this.keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState == null ? null : keyState.toString());
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final Integer getPendingWindowInDays() {
            return this.pendingWindowInDays;
        }

        @Override
        public final Builder pendingWindowInDays(Integer pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
            return this;
        }

        public final void setPendingWindowInDays(Integer pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
        }

        @Override
        public ScheduleKeyDeletionResponse build() {
            return new ScheduleKeyDeletionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ScheduleKeyDeletionResponse> {
        public Builder keyId(String var1);

        public Builder deletionDate(Instant var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder pendingWindowInDays(Integer var1);
    }
}

