/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.KeyListCopier;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeysResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ListKeysResponse> {
    private static final SdkField<List<KeyListEntry>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListKeysResponse.getter(ListKeysResponse::keys)).setter(ListKeysResponse.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListKeysResponse.getter(ListKeysResponse::nextMarker)).setter(ListKeysResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListKeysResponse.getter(ListKeysResponse::truncated)).setter(ListKeysResponse.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYS_FIELD, NEXT_MARKER_FIELD, TRUNCATED_FIELD));
    private final List<KeyListEntry> keys;
    private final String nextMarker;
    private final Boolean truncated;

    private ListKeysResponse(BuilderImpl builder) {
        super(builder);
        this.keys = builder.keys;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public List<KeyListEntry> keys() {
        return this.keys;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResponse)) {
            return false;
        }
        ListKeysResponse other = (ListKeysResponse)((Object)obj);
        return Objects.equals(this.keys(), other.keys()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.truncated(), other.truncated());
    }

    public String toString() {
        return ToString.builder((String)"ListKeysResponse").add("Keys", this.keys()).add("NextMarker", (Object)this.nextMarker()).add("Truncated", (Object)this.truncated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKeysResponse, T> g) {
        return obj -> g.apply((ListKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private List<KeyListEntry> keys = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeysResponse model) {
            super(model);
            this.keys(model.keys);
            this.nextMarker(model.nextMarker);
            this.truncated(model.truncated);
        }

        public final Collection<KeyListEntry.Builder> getKeys() {
            return this.keys != null ? (Collection)this.keys.stream().map(KeyListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keys(Collection<KeyListEntry> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(KeyListEntry ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<KeyListEntry.Builder> ... keys) {
            this.keys(Stream.of(keys).map(c -> (KeyListEntry)((KeyListEntry.Builder)KeyListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeys(Collection<KeyListEntry.BuilderImpl> keys) {
            this.keys = KeyListCopier.copyFromBuilder(keys);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public ListKeysResponse build() {
            return new ListKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeysResponse> {
        public Builder keys(Collection<KeyListEntry> var1);

        public Builder keys(KeyListEntry ... var1);

        public Builder keys(Consumer<KeyListEntry.Builder> ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

