/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, SignResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignResponse.getter(SignResponse::keyId)).setter(SignResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(SignResponse.getter(SignResponse::signature)).setter(SignResponse.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SignResponse.getter(SignResponse::signingAlgorithmAsString)).setter(SignResponse.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, SIGNATURE_FIELD, SIGNING_ALGORITHM_FIELD));
    private final String keyId;
    private final SdkBytes signature;
    private final String signingAlgorithm;

    private SignResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.signature = builder.signature;
        this.signingAlgorithm = builder.signingAlgorithm;
    }

    public String keyId() {
        return this.keyId;
    }

    public SdkBytes signature() {
        return this.signature;
    }

    public SigningAlgorithmSpec signingAlgorithm() {
        return SigningAlgorithmSpec.fromValue(this.signingAlgorithm);
    }

    public String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignResponse)) {
            return false;
        }
        SignResponse other = (SignResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.signature(), other.signature()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString());
    }

    public String toString() {
        return ToString.builder((String)"SignResponse").add("KeyId", (Object)this.keyId()).add("Signature", (Object)this.signature()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignResponse, T> g) {
        return obj -> g.apply((SignResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes signature;
        private String signingAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(SignResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.signature(model.signature);
            this.signingAlgorithm(model.signingAlgorithm);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getSignature() {
            return this.signature == null ? null : this.signature.asByteBuffer();
        }

        @Override
        public final Builder signature(SdkBytes signature) {
            this.signature = StandardMemberCopier.copy((SdkBytes)signature);
            return this;
        }

        public final void setSignature(ByteBuffer signature) {
            this.signature(signature == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)signature));
        }

        public final String getSigningAlgorithmAsString() {
            return this.signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithmSpec signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public SignResponse build() {
            return new SignResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SignResponse> {
        public Builder keyId(String var1);

        public Builder signature(SdkBytes var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithmSpec var1);
    }
}

