/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.AliasListEntry;
import software.amazon.awssdk.services.kms.model.ListAliasesRequest;
import software.amazon.awssdk.services.kms.model.ListAliasesResponse;

public class ListAliasesIterable
implements SdkIterable<ListAliasesResponse> {
    private final KmsClient client;
    private final ListAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAliasesIterable(KmsClient client, ListAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public Iterator<ListAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AliasListEntry> aliases() {
        Function<ListAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.aliases() != null) {
                return response.aliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListAliasesIterable resume(ListAliasesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAliasesIterable(this.client, (ListAliasesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListAliasesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAliasesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAliasesResponseFetcher
    implements SyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return previousPage.truncated();
        }

        public ListAliasesResponse nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesIterable.this.client.listAliases(ListAliasesIterable.this.firstRequest);
            }
            return ListAliasesIterable.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

