/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesStreamsRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.ShardFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamRequest
extends KeyspacesStreamsRequest
implements ToCopyableBuilder<Builder, GetStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamArn").getter(GetStreamRequest.getter(GetStreamRequest::streamArn)).setter(GetStreamRequest.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetStreamRequest.getter(GetStreamRequest::maxResults)).setter(GetStreamRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<ShardFilter> SHARD_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("shardFilter").getter(GetStreamRequest.getter(GetStreamRequest::shardFilter)).setter(GetStreamRequest.setter(Builder::shardFilter)).constructor(ShardFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetStreamRequest.getter(GetStreamRequest::nextToken)).setter(GetStreamRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, MAX_RESULTS_FIELD, SHARD_FILTER_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetStreamRequest.memberNameToFieldInitializer();
    private final String streamArn;
    private final Integer maxResults;
    private final ShardFilter shardFilter;
    private final String nextToken;

    private GetStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.maxResults = builder.maxResults;
        this.shardFilter = builder.shardFilter;
        this.nextToken = builder.nextToken;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ShardFilter shardFilter() {
        return this.shardFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamRequest)) {
            return false;
        }
        GetStreamRequest other = (GetStreamRequest)((Object)obj);
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.shardFilter(), other.shardFilter()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamRequest").add("StreamArn", (Object)this.streamArn()).add("MaxResults", (Object)this.maxResults()).add("ShardFilter", (Object)this.shardFilter()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "shardFilter": {
                return Optional.ofNullable(clazz.cast(this.shardFilter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("shardFilter", SHARD_FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamRequest, T> g) {
        return obj -> g.apply((GetStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesStreamsRequest.BuilderImpl
    implements Builder {
        private String streamArn;
        private Integer maxResults;
        private ShardFilter shardFilter;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamRequest model) {
            super(model);
            this.streamArn(model.streamArn);
            this.maxResults(model.maxResults);
            this.shardFilter(model.shardFilter);
            this.nextToken(model.nextToken);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ShardFilter.Builder getShardFilter() {
            return this.shardFilter != null ? this.shardFilter.toBuilder() : null;
        }

        public final void setShardFilter(ShardFilter.BuilderImpl shardFilter) {
            this.shardFilter = shardFilter != null ? shardFilter.build() : null;
        }

        @Override
        public final Builder shardFilter(ShardFilter shardFilter) {
            this.shardFilter = shardFilter;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStreamRequest build() {
            return new GetStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KeyspacesStreamsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamRequest> {
        public Builder streamArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder shardFilter(ShardFilter var1);

        default public Builder shardFilter(Consumer<ShardFilter.Builder> shardFilter) {
            return this.shardFilter((ShardFilter)((ShardFilter.Builder)ShardFilter.builder().applyMutation(shardFilter)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

