/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamsResponse extends KeyspacesStreamsResponse implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private static final SdkField<List<Stream>> STREAMS_FIELD = SdkField
            .<List<Stream>> builder(MarshallingType.LIST)
            .memberName("streams")
            .getter(getter(ListStreamsResponse::streams))
            .setter(setter(Builder::streams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Stream> builder(MarshallingType.SDK_POJO)
                                            .constructor(Stream::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Stream> streams;

    private final String nextToken;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Streams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreams() {
        return streams != null && !(streams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of stream objects, each containing summary information about a stream including its ARN, status, and
     * associated table information. This list includes all streams that match the request criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreams} method.
     * </p>
     * 
     * @return An array of stream objects, each containing summary information about a stream including its ARN, status,
     *         and associated table information. This list includes all streams that match the request criteria.
     */
    public final List<Stream> streams() {
        return streams;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent <code>ListStreams</code> request. This token is returned if
     * the response contains more streams than can be returned in a single response based on the <code>MaxResults</code>
     * parameter.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent <code>ListStreams</code> request. This token is
     *         returned if the response contains more streams than can be returned in a single response based on the
     *         <code>MaxResults</code> parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStreams() ? streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        return hasStreams() == other.hasStreams() && Objects.equals(streams(), other.streams())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamsResponse").add("Streams", hasStreams() ? streams() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streams", STREAMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsResponse, T> g) {
        return obj -> g.apply((ListStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesStreamsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * An array of stream objects, each containing summary information about a stream including its ARN, status, and
         * associated table information. This list includes all streams that match the request criteria.
         * </p>
         * 
         * @param streams
         *        An array of stream objects, each containing summary information about a stream including its ARN,
         *        status, and associated table information. This list includes all streams that match the request
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<Stream> streams);

        /**
         * <p>
         * An array of stream objects, each containing summary information about a stream including its ARN, status, and
         * associated table information. This list includes all streams that match the request criteria.
         * </p>
         * 
         * @param streams
         *        An array of stream objects, each containing summary information about a stream including its ARN,
         *        status, and associated table information. This list includes all streams that match the request
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Stream... streams);

        /**
         * <p>
         * An array of stream objects, each containing summary information about a stream including its ARN, status, and
         * associated table information. This list includes all streams that match the request criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.Stream.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.keyspacesstreams.model.Stream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspacesstreams.model.Stream.Builder#build()} is called immediately
         * and its result is passed to {@link #streams(List<Stream>)}.
         * 
         * @param streams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspacesstreams.model.Stream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(java.util.Collection<Stream>)
         */
        Builder streams(Consumer<Stream.Builder>... streams);

        /**
         * <p>
         * A pagination token that can be used in a subsequent <code>ListStreams</code> request. This token is returned
         * if the response contains more streams than can be returned in a single response based on the
         * <code>MaxResults</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent <code>ListStreams</code> request. This token is
         *        returned if the response contains more streams than can be returned in a single response based on the
         *        <code>MaxResults</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KeyspacesStreamsResponse.BuilderImpl implements Builder {
        private List<Stream> streams = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            streams(model.streams);
            nextToken(model.nextToken);
        }

        public final List<Stream.Builder> getStreams() {
            List<Stream.Builder> result = StreamListCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<Stream.BuilderImpl> streams) {
            this.streams = StreamListCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<Stream> streams) {
            this.streams = StreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Stream... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<Stream.Builder>... streams) {
            streams(java.util.stream.Stream.of(streams).map(c -> Stream.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
