/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamRequest extends KeyspacesStreamsRequest implements
        ToCopyableBuilder<GetStreamRequest.Builder, GetStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamArn").getter(getter(GetStreamRequest::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetStreamRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<ShardFilter> SHARD_FILTER_FIELD = SdkField.<ShardFilter> builder(MarshallingType.SDK_POJO)
            .memberName("shardFilter").getter(getter(GetStreamRequest::shardFilter)).setter(setter(Builder::shardFilter))
            .constructor(ShardFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardFilter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetStreamRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            MAX_RESULTS_FIELD, SHARD_FILTER_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamArn;

    private final Integer maxResults;

    private final ShardFilter shardFilter;

    private final String nextToken;

    private GetStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.maxResults = builder.maxResults;
        this.shardFilter = builder.shardFilter;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream for which detailed information is requested. This uniquely
     * identifies the specific stream you want to get information about.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream for which detailed information is requested. This uniquely
     *         identifies the specific stream you want to get information about.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The maximum number of shard objects to return in a single <code>GetStream</code> request. Default value is 100.
     * The minimum value is 1 and the maximum value is 100.
     * </p>
     * 
     * @return The maximum number of shard objects to return in a single <code>GetStream</code> request. Default value
     *         is 100. The minimum value is 1 and the maximum value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Optional filter criteria to apply when retrieving shards. You can filter shards based on their state or other
     * attributes to narrow down the results returned by the <code>GetStream</code> operation.
     * </p>
     * 
     * @return Optional filter criteria to apply when retrieving shards. You can filter shards based on their state or
     *         other attributes to narrow down the results returned by the <code>GetStream</code> operation.
     */
    public final ShardFilter shardFilter() {
        return shardFilter;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>GetStream</code> operation. If this parameter is
     * specified, the response includes only records beyond the token, up to the value specified by
     * <code>maxResults</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>GetStream</code> operation. If this parameter
     *         is specified, the response includes only records beyond the token, up to the value specified by
     *         <code>maxResults</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(shardFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamRequest)) {
            return false;
        }
        GetStreamRequest other = (GetStreamRequest) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(shardFilter(), other.shardFilter()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamRequest").add("StreamArn", streamArn()).add("MaxResults", maxResults())
                .add("ShardFilter", shardFilter()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "shardFilter":
            return Optional.ofNullable(clazz.cast(shardFilter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamArn", STREAM_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("shardFilter", SHARD_FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamRequest, T> g) {
        return obj -> g.apply((GetStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream for which detailed information is requested. This uniquely
         * identifies the specific stream you want to get information about.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) of the stream for which detailed information is requested. This
         *        uniquely identifies the specific stream you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The maximum number of shard objects to return in a single <code>GetStream</code> request. Default value is
         * 100. The minimum value is 1 and the maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of shard objects to return in a single <code>GetStream</code> request. Default
         *        value is 100. The minimum value is 1 and the maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Optional filter criteria to apply when retrieving shards. You can filter shards based on their state or other
         * attributes to narrow down the results returned by the <code>GetStream</code> operation.
         * </p>
         * 
         * @param shardFilter
         *        Optional filter criteria to apply when retrieving shards. You can filter shards based on their state
         *        or other attributes to narrow down the results returned by the <code>GetStream</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardFilter(ShardFilter shardFilter);

        /**
         * <p>
         * Optional filter criteria to apply when retrieving shards. You can filter shards based on their state or other
         * attributes to narrow down the results returned by the <code>GetStream</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShardFilter.Builder} avoiding the need to
         * create one manually via {@link ShardFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShardFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #shardFilter(ShardFilter)}.
         * 
         * @param shardFilter
         *        a consumer that will call methods on {@link ShardFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shardFilter(ShardFilter)
         */
        default Builder shardFilter(Consumer<ShardFilter.Builder> shardFilter) {
            return shardFilter(ShardFilter.builder().applyMutation(shardFilter).build());
        }

        /**
         * <p>
         * An optional pagination token provided by a previous <code>GetStream</code> operation. If this parameter is
         * specified, the response includes only records beyond the token, up to the value specified by
         * <code>maxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous <code>GetStream</code> operation. If this
         *        parameter is specified, the response includes only records beyond the token, up to the value specified
         *        by <code>maxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesStreamsRequest.BuilderImpl implements Builder {
        private String streamArn;

        private Integer maxResults;

        private ShardFilter shardFilter;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamRequest model) {
            super(model);
            streamArn(model.streamArn);
            maxResults(model.maxResults);
            shardFilter(model.shardFilter);
            nextToken(model.nextToken);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ShardFilter.Builder getShardFilter() {
            return shardFilter != null ? shardFilter.toBuilder() : null;
        }

        public final void setShardFilter(ShardFilter.BuilderImpl shardFilter) {
            this.shardFilter = shardFilter != null ? shardFilter.build() : null;
        }

        @Override
        public final Builder shardFilter(ShardFilter shardFilter) {
            this.shardFilter = shardFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStreamRequest build() {
            return new GetStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
