/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamsRequest extends KeyspacesStreamsRequest implements
        ToCopyableBuilder<ListStreamsRequest.Builder, ListStreamsRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(ListStreamsRequest::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(ListStreamsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListStreamsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TABLE_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String keyspaceName;

    private final String tableName;

    private final Integer maxResults;

    private final String nextToken;

    private ListStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the keyspace for which to list streams. If specified, only streams associated with tables in this
     * keyspace are returned. If omitted, streams from all keyspaces are included in the results.
     * </p>
     * 
     * @return The name of the keyspace for which to list streams. If specified, only streams associated with tables in
     *         this keyspace are returned. If omitted, streams from all keyspaces are included in the results.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the table for which to list streams. Must be used together with <code>keyspaceName</code>. If
     * specified, only streams associated with this specific table are returned.
     * </p>
     * 
     * @return The name of the table for which to list streams. Must be used together with <code>keyspaceName</code>. If
     *         specified, only streams associated with this specific table are returned.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The maximum number of streams to return in a single <code>ListStreams</code> request. Default value is 100. The
     * minimum value is 1 and the maximum value is 100.
     * </p>
     * 
     * @return The maximum number of streams to return in a single <code>ListStreams</code> request. Default value is
     *         100. The minimum value is 1 and the maximum value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>ListStreams</code> operation. If this parameter is
     * specified, the response includes only records beyond the token, up to the value specified by
     * <code>maxResults</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>ListStreams</code> operation. If this parameter
     *         is specified, the response includes only records beyond the token, up to the value specified by
     *         <code>maxResults</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamsRequest").add("KeyspaceName", keyspaceName()).add("TableName", tableName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("keyspaceName", KEYSPACE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsRequest, T> g) {
        return obj -> g.apply((ListStreamsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KeyspacesStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamsRequest> {
        /**
         * <p>
         * The name of the keyspace for which to list streams. If specified, only streams associated with tables in this
         * keyspace are returned. If omitted, streams from all keyspaces are included in the results.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace for which to list streams. If specified, only streams associated with tables
         *        in this keyspace are returned. If omitted, streams from all keyspaces are included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the table for which to list streams. Must be used together with <code>keyspaceName</code>. If
         * specified, only streams associated with this specific table are returned.
         * </p>
         * 
         * @param tableName
         *        The name of the table for which to list streams. Must be used together with <code>keyspaceName</code>.
         *        If specified, only streams associated with this specific table are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The maximum number of streams to return in a single <code>ListStreams</code> request. Default value is 100.
         * The minimum value is 1 and the maximum value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of streams to return in a single <code>ListStreams</code> request. Default value is
         *        100. The minimum value is 1 and the maximum value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>ListStreams</code> operation. If this parameter is
         * specified, the response includes only records beyond the token, up to the value specified by
         * <code>maxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous <code>ListStreams</code> operation. If this
         *        parameter is specified, the response includes only records beyond the token, up to the value specified
         *        by <code>maxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesStreamsRequest.BuilderImpl implements Builder {
        private String keyspaceName;

        private String tableName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            super(model);
            keyspaceName(model.keyspaceName);
            tableName(model.tableName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
