/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspacesstreams.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class KeyspacesCellsCopier {
    static Map<String, KeyspacesCell> copy(Map<String, ? extends KeyspacesCell> keyspacesCellsParam) {
        Map<String, KeyspacesCell> map;
        if (keyspacesCellsParam == null || keyspacesCellsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, KeyspacesCell> modifiableMap = new LinkedHashMap<>(keyspacesCellsParam.size());
            keyspacesCellsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, KeyspacesCell> copyFromBuilder(Map<String, ? extends KeyspacesCell.Builder> keyspacesCellsParam) {
        Map<String, KeyspacesCell> map;
        if (keyspacesCellsParam == null || keyspacesCellsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, KeyspacesCell> modifiableMap = new LinkedHashMap<>(keyspacesCellsParam.size());
            keyspacesCellsParam.forEach((key, value) -> {
                KeyspacesCell member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, KeyspacesCell.Builder> copyToBuilder(Map<String, ? extends KeyspacesCell> keyspacesCellsParam) {
        Map<String, KeyspacesCell.Builder> map;
        if (keyspacesCellsParam == null || keyspacesCellsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, KeyspacesCell.Builder> modifiableMap = new LinkedHashMap<>(keyspacesCellsParam.size());
            keyspacesCellsParam.forEach((key, value) -> {
                KeyspacesCell.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
