/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary;
import software.amazon.awssdk.services.keyspaces.model.Comment;
import software.amazon.awssdk.services.keyspaces.model.EncryptionSpecification;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.PointInTimeRecoverySummary;
import software.amazon.awssdk.services.keyspaces.model.SchemaDefinition;
import software.amazon.awssdk.services.keyspaces.model.TableStatus;
import software.amazon.awssdk.services.keyspaces.model.TimeToLive;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableResponse
extends KeyspacesResponse
implements ToCopyableBuilder<Builder, GetTableResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetTableResponse.getter(GetTableResponse::keyspaceName)).setter(GetTableResponse.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(GetTableResponse.getter(GetTableResponse::tableName)).setter(GetTableResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(GetTableResponse.getter(GetTableResponse::resourceArn)).setter(GetTableResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(GetTableResponse.getter(GetTableResponse::creationTimestamp)).setter(GetTableResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTableResponse.getter(GetTableResponse::statusAsString)).setter(GetTableResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<SchemaDefinition> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schemaDefinition").getter(GetTableResponse.getter(GetTableResponse::schemaDefinition)).setter(GetTableResponse.setter(Builder::schemaDefinition)).constructor(SchemaDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()}).build();
    private static final SdkField<CapacitySpecificationSummary> CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacitySpecification").getter(GetTableResponse.getter(GetTableResponse::capacitySpecification)).setter(GetTableResponse.setter(Builder::capacitySpecification)).constructor(CapacitySpecificationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build()}).build();
    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionSpecification").getter(GetTableResponse.getter(GetTableResponse::encryptionSpecification)).setter(GetTableResponse.setter(Builder::encryptionSpecification)).constructor(EncryptionSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecification").build()}).build();
    private static final SdkField<PointInTimeRecoverySummary> POINT_IN_TIME_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pointInTimeRecovery").getter(GetTableResponse.getter(GetTableResponse::pointInTimeRecovery)).setter(GetTableResponse.setter(Builder::pointInTimeRecovery)).constructor(PointInTimeRecoverySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecovery").build()}).build();
    private static final SdkField<TimeToLive> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ttl").getter(GetTableResponse.getter(GetTableResponse::ttl)).setter(GetTableResponse.setter(Builder::ttl)).constructor(TimeToLive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<Integer> DEFAULT_TIME_TO_LIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultTimeToLive").getter(GetTableResponse.getter(GetTableResponse::defaultTimeToLive)).setter(GetTableResponse.setter(Builder::defaultTimeToLive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTimeToLive").build()}).build();
    private static final SdkField<Comment> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("comment").getter(GetTableResponse.getter(GetTableResponse::comment)).setter(GetTableResponse.setter(Builder::comment)).constructor(Comment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TABLE_NAME_FIELD, RESOURCE_ARN_FIELD, CREATION_TIMESTAMP_FIELD, STATUS_FIELD, SCHEMA_DEFINITION_FIELD, CAPACITY_SPECIFICATION_FIELD, ENCRYPTION_SPECIFICATION_FIELD, POINT_IN_TIME_RECOVERY_FIELD, TTL_FIELD, DEFAULT_TIME_TO_LIVE_FIELD, COMMENT_FIELD));
    private final String keyspaceName;
    private final String tableName;
    private final String resourceArn;
    private final Instant creationTimestamp;
    private final String status;
    private final SchemaDefinition schemaDefinition;
    private final CapacitySpecificationSummary capacitySpecification;
    private final EncryptionSpecification encryptionSpecification;
    private final PointInTimeRecoverySummary pointInTimeRecovery;
    private final TimeToLive ttl;
    private final Integer defaultTimeToLive;
    private final Comment comment;

    private GetTableResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.resourceArn = builder.resourceArn;
        this.creationTimestamp = builder.creationTimestamp;
        this.status = builder.status;
        this.schemaDefinition = builder.schemaDefinition;
        this.capacitySpecification = builder.capacitySpecification;
        this.encryptionSpecification = builder.encryptionSpecification;
        this.pointInTimeRecovery = builder.pointInTimeRecovery;
        this.ttl = builder.ttl;
        this.defaultTimeToLive = builder.defaultTimeToLive;
        this.comment = builder.comment;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final TableStatus status() {
        return TableStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SchemaDefinition schemaDefinition() {
        return this.schemaDefinition;
    }

    public final CapacitySpecificationSummary capacitySpecification() {
        return this.capacitySpecification;
    }

    public final EncryptionSpecification encryptionSpecification() {
        return this.encryptionSpecification;
    }

    public final PointInTimeRecoverySummary pointInTimeRecovery() {
        return this.pointInTimeRecovery;
    }

    public final TimeToLive ttl() {
        return this.ttl;
    }

    public final Integer defaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public final Comment comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTimeToLive());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableResponse)) {
            return false;
        }
        GetTableResponse other = (GetTableResponse)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition()) && Objects.equals(this.capacitySpecification(), other.capacitySpecification()) && Objects.equals(this.encryptionSpecification(), other.encryptionSpecification()) && Objects.equals(this.pointInTimeRecovery(), other.pointInTimeRecovery()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.defaultTimeToLive(), other.defaultTimeToLive()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableResponse").add("KeyspaceName", (Object)this.keyspaceName()).add("TableName", (Object)this.tableName()).add("ResourceArn", (Object)this.resourceArn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Status", (Object)this.statusAsString()).add("SchemaDefinition", (Object)this.schemaDefinition()).add("CapacitySpecification", (Object)this.capacitySpecification()).add("EncryptionSpecification", (Object)this.encryptionSpecification()).add("PointInTimeRecovery", (Object)this.pointInTimeRecovery()).add("Ttl", (Object)this.ttl()).add("DefaultTimeToLive", (Object)this.defaultTimeToLive()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "schemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
            case "capacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.capacitySpecification()));
            }
            case "encryptionSpecification": {
                return Optional.ofNullable(clazz.cast(this.encryptionSpecification()));
            }
            case "pointInTimeRecovery": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecovery()));
            }
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "defaultTimeToLive": {
                return Optional.ofNullable(clazz.cast(this.defaultTimeToLive()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableResponse, T> g) {
        return obj -> g.apply((GetTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesResponse.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String tableName;
        private String resourceArn;
        private Instant creationTimestamp;
        private String status;
        private SchemaDefinition schemaDefinition;
        private CapacitySpecificationSummary capacitySpecification;
        private EncryptionSpecification encryptionSpecification;
        private PointInTimeRecoverySummary pointInTimeRecovery;
        private TimeToLive ttl;
        private Integer defaultTimeToLive;
        private Comment comment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableResponse model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.tableName(model.tableName);
            this.resourceArn(model.resourceArn);
            this.creationTimestamp(model.creationTimestamp);
            this.status(model.status);
            this.schemaDefinition(model.schemaDefinition);
            this.capacitySpecification(model.capacitySpecification);
            this.encryptionSpecification(model.encryptionSpecification);
            this.pointInTimeRecovery(model.pointInTimeRecovery);
            this.ttl(model.ttl);
            this.defaultTimeToLive(model.defaultTimeToLive);
            this.comment(model.comment);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SchemaDefinition.Builder getSchemaDefinition() {
            return this.schemaDefinition != null ? this.schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaDefinition.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaDefinition schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final CapacitySpecificationSummary.Builder getCapacitySpecification() {
            return this.capacitySpecification != null ? this.capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecificationSummary.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecificationSummary capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecification() {
            return this.encryptionSpecification != null ? this.encryptionSpecification.toBuilder() : null;
        }

        public final void setEncryptionSpecification(EncryptionSpecification.BuilderImpl encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification != null ? encryptionSpecification.build() : null;
        }

        @Override
        public final Builder encryptionSpecification(EncryptionSpecification encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        public final PointInTimeRecoverySummary.Builder getPointInTimeRecovery() {
            return this.pointInTimeRecovery != null ? this.pointInTimeRecovery.toBuilder() : null;
        }

        public final void setPointInTimeRecovery(PointInTimeRecoverySummary.BuilderImpl pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery != null ? pointInTimeRecovery.build() : null;
        }

        @Override
        public final Builder pointInTimeRecovery(PointInTimeRecoverySummary pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public final TimeToLive.Builder getTtl() {
            return this.ttl != null ? this.ttl.toBuilder() : null;
        }

        public final void setTtl(TimeToLive.BuilderImpl ttl) {
            this.ttl = ttl != null ? ttl.build() : null;
        }

        @Override
        public final Builder ttl(TimeToLive ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Integer getDefaultTimeToLive() {
            return this.defaultTimeToLive;
        }

        public final void setDefaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
        }

        @Override
        public final Builder defaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
            return this;
        }

        public final Comment.Builder getComment() {
            return this.comment != null ? this.comment.toBuilder() : null;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public GetTableResponse build() {
            return new GetTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KeyspacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableResponse> {
        public Builder keyspaceName(String var1);

        public Builder tableName(String var1);

        public Builder resourceArn(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(TableStatus var1);

        public Builder schemaDefinition(SchemaDefinition var1);

        default public Builder schemaDefinition(Consumer<SchemaDefinition.Builder> schemaDefinition) {
            return this.schemaDefinition((SchemaDefinition)((SchemaDefinition.Builder)SchemaDefinition.builder().applyMutation(schemaDefinition)).build());
        }

        public Builder capacitySpecification(CapacitySpecificationSummary var1);

        default public Builder capacitySpecification(Consumer<CapacitySpecificationSummary.Builder> capacitySpecification) {
            return this.capacitySpecification((CapacitySpecificationSummary)((CapacitySpecificationSummary.Builder)CapacitySpecificationSummary.builder().applyMutation(capacitySpecification)).build());
        }

        public Builder encryptionSpecification(EncryptionSpecification var1);

        default public Builder encryptionSpecification(Consumer<EncryptionSpecification.Builder> encryptionSpecification) {
            return this.encryptionSpecification((EncryptionSpecification)((EncryptionSpecification.Builder)EncryptionSpecification.builder().applyMutation(encryptionSpecification)).build());
        }

        public Builder pointInTimeRecovery(PointInTimeRecoverySummary var1);

        default public Builder pointInTimeRecovery(Consumer<PointInTimeRecoverySummary.Builder> pointInTimeRecovery) {
            return this.pointInTimeRecovery((PointInTimeRecoverySummary)((PointInTimeRecoverySummary.Builder)PointInTimeRecoverySummary.builder().applyMutation(pointInTimeRecovery)).build());
        }

        public Builder ttl(TimeToLive var1);

        default public Builder ttl(Consumer<TimeToLive.Builder> ttl) {
            return this.ttl((TimeToLive)((TimeToLive.Builder)TimeToLive.builder().applyMutation(ttl)).build());
        }

        public Builder defaultTimeToLive(Integer var1);

        public Builder comment(Comment var1);

        default public Builder comment(Consumer<Comment.Builder> comment) {
            return this.comment((Comment)((Comment.Builder)Comment.builder().applyMutation(comment)).build());
        }
    }
}

