/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.EntityIdsListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociatePersonasFromEntitiesRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, DisassociatePersonasFromEntitiesRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DisassociatePersonasFromEntitiesRequest.getter(DisassociatePersonasFromEntitiesRequest::id)).setter(DisassociatePersonasFromEntitiesRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(DisassociatePersonasFromEntitiesRequest.getter(DisassociatePersonasFromEntitiesRequest::indexId)).setter(DisassociatePersonasFromEntitiesRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<List<String>> ENTITY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityIds").getter(DisassociatePersonasFromEntitiesRequest.getter(DisassociatePersonasFromEntitiesRequest::entityIds)).setter(DisassociatePersonasFromEntitiesRequest.setter(Builder::entityIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD, ENTITY_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociatePersonasFromEntitiesRequest.memberNameToFieldInitializer();
    private final String id;
    private final String indexId;
    private final List<String> entityIds;

    private DisassociatePersonasFromEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.entityIds = builder.entityIds;
    }

    public final String id() {
        return this.id;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final boolean hasEntityIds() {
        return this.entityIds != null && !(this.entityIds instanceof SdkAutoConstructList);
    }

    public final List<String> entityIds() {
        return this.entityIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityIds() ? this.entityIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociatePersonasFromEntitiesRequest)) {
            return false;
        }
        DisassociatePersonasFromEntitiesRequest other = (DisassociatePersonasFromEntitiesRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.indexId(), other.indexId()) && this.hasEntityIds() == other.hasEntityIds() && Objects.equals(this.entityIds(), other.entityIds());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociatePersonasFromEntitiesRequest").add("Id", (Object)this.id()).add("IndexId", (Object)this.indexId()).add("EntityIds", this.hasEntityIds() ? this.entityIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "EntityIds": {
                return Optional.ofNullable(clazz.cast(this.entityIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("EntityIds", ENTITY_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociatePersonasFromEntitiesRequest, T> g) {
        return obj -> g.apply((DisassociatePersonasFromEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String id;
        private String indexId;
        private List<String> entityIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociatePersonasFromEntitiesRequest model) {
            super(model);
            this.id(model.id);
            this.indexId(model.indexId);
            this.entityIds(model.entityIds);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Collection<String> getEntityIds() {
            if (this.entityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityIds;
        }

        public final void setEntityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdsListCopier.copy(entityIds);
        }

        @Override
        public final Builder entityIds(Collection<String> entityIds) {
            this.entityIds = EntityIdsListCopier.copy(entityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityIds(String ... entityIds) {
            this.entityIds(Arrays.asList(entityIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociatePersonasFromEntitiesRequest build() {
            return new DisassociatePersonasFromEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociatePersonasFromEntitiesRequest> {
        public Builder id(String var1);

        public Builder indexId(String var1);

        public Builder entityIds(Collection<String> var1);

        public Builder entityIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

