/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ChangeDetectingColumnsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnConfiguration> {
    private static final SdkField<String> DOCUMENT_ID_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentIdColumnName").getter(ColumnConfiguration.getter(ColumnConfiguration::documentIdColumnName)).setter(ColumnConfiguration.setter(Builder::documentIdColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdColumnName").build()}).build();
    private static final SdkField<String> DOCUMENT_DATA_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentDataColumnName").getter(ColumnConfiguration.getter(ColumnConfiguration::documentDataColumnName)).setter(ColumnConfiguration.setter(Builder::documentDataColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataColumnName").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentTitleColumnName").getter(ColumnConfiguration.getter(ColumnConfiguration::documentTitleColumnName)).setter(ColumnConfiguration.setter(Builder::documentTitleColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleColumnName").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(ColumnConfiguration.getter(ColumnConfiguration::fieldMappings)).setter(ColumnConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CHANGE_DETECTING_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeDetectingColumns").getter(ColumnConfiguration.getter(ColumnConfiguration::changeDetectingColumns)).setter(ColumnConfiguration.setter(Builder::changeDetectingColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeDetectingColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_COLUMN_NAME_FIELD, DOCUMENT_DATA_COLUMN_NAME_FIELD, DOCUMENT_TITLE_COLUMN_NAME_FIELD, FIELD_MAPPINGS_FIELD, CHANGE_DETECTING_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColumnConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String documentIdColumnName;
    private final String documentDataColumnName;
    private final String documentTitleColumnName;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;
    private final List<String> changeDetectingColumns;

    private ColumnConfiguration(BuilderImpl builder) {
        this.documentIdColumnName = builder.documentIdColumnName;
        this.documentDataColumnName = builder.documentDataColumnName;
        this.documentTitleColumnName = builder.documentTitleColumnName;
        this.fieldMappings = builder.fieldMappings;
        this.changeDetectingColumns = builder.changeDetectingColumns;
    }

    public final String documentIdColumnName() {
        return this.documentIdColumnName;
    }

    public final String documentDataColumnName() {
        return this.documentDataColumnName;
    }

    public final String documentTitleColumnName() {
        return this.documentTitleColumnName;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public final boolean hasChangeDetectingColumns() {
        return this.changeDetectingColumns != null && !(this.changeDetectingColumns instanceof SdkAutoConstructList);
    }

    public final List<String> changeDetectingColumns() {
        return this.changeDetectingColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDataColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitleColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeDetectingColumns() ? this.changeDetectingColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnConfiguration)) {
            return false;
        }
        ColumnConfiguration other = (ColumnConfiguration)obj;
        return Objects.equals(this.documentIdColumnName(), other.documentIdColumnName()) && Objects.equals(this.documentDataColumnName(), other.documentDataColumnName()) && Objects.equals(this.documentTitleColumnName(), other.documentTitleColumnName()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings()) && this.hasChangeDetectingColumns() == other.hasChangeDetectingColumns() && Objects.equals(this.changeDetectingColumns(), other.changeDetectingColumns());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnConfiguration").add("DocumentIdColumnName", (Object)this.documentIdColumnName()).add("DocumentDataColumnName", (Object)this.documentDataColumnName()).add("DocumentTitleColumnName", (Object)this.documentTitleColumnName()).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).add("ChangeDetectingColumns", this.hasChangeDetectingColumns() ? this.changeDetectingColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentIdColumnName": {
                return Optional.ofNullable(clazz.cast(this.documentIdColumnName()));
            }
            case "DocumentDataColumnName": {
                return Optional.ofNullable(clazz.cast(this.documentDataColumnName()));
            }
            case "DocumentTitleColumnName": {
                return Optional.ofNullable(clazz.cast(this.documentTitleColumnName()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
            case "ChangeDetectingColumns": {
                return Optional.ofNullable(clazz.cast(this.changeDetectingColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentIdColumnName", DOCUMENT_ID_COLUMN_NAME_FIELD);
        map.put("DocumentDataColumnName", DOCUMENT_DATA_COLUMN_NAME_FIELD);
        map.put("DocumentTitleColumnName", DOCUMENT_TITLE_COLUMN_NAME_FIELD);
        map.put("FieldMappings", FIELD_MAPPINGS_FIELD);
        map.put("ChangeDetectingColumns", CHANGE_DETECTING_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnConfiguration, T> g) {
        return obj -> g.apply((ColumnConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentIdColumnName;
        private String documentDataColumnName;
        private String documentTitleColumnName;
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> changeDetectingColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnConfiguration model) {
            this.documentIdColumnName(model.documentIdColumnName);
            this.documentDataColumnName(model.documentDataColumnName);
            this.documentTitleColumnName(model.documentTitleColumnName);
            this.fieldMappings(model.fieldMappings);
            this.changeDetectingColumns(model.changeDetectingColumns);
        }

        public final String getDocumentIdColumnName() {
            return this.documentIdColumnName;
        }

        public final void setDocumentIdColumnName(String documentIdColumnName) {
            this.documentIdColumnName = documentIdColumnName;
        }

        @Override
        public final Builder documentIdColumnName(String documentIdColumnName) {
            this.documentIdColumnName = documentIdColumnName;
            return this;
        }

        public final String getDocumentDataColumnName() {
            return this.documentDataColumnName;
        }

        public final void setDocumentDataColumnName(String documentDataColumnName) {
            this.documentDataColumnName = documentDataColumnName;
        }

        @Override
        public final Builder documentDataColumnName(String documentDataColumnName) {
            this.documentDataColumnName = documentDataColumnName;
            return this;
        }

        public final String getDocumentTitleColumnName() {
            return this.documentTitleColumnName;
        }

        public final void setDocumentTitleColumnName(String documentTitleColumnName) {
            this.documentTitleColumnName = documentTitleColumnName;
        }

        @Override
        public final Builder documentTitleColumnName(String documentTitleColumnName) {
            this.documentTitleColumnName = documentTitleColumnName;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getChangeDetectingColumns() {
            if (this.changeDetectingColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.changeDetectingColumns;
        }

        public final void setChangeDetectingColumns(Collection<String> changeDetectingColumns) {
            this.changeDetectingColumns = ChangeDetectingColumnsCopier.copy(changeDetectingColumns);
        }

        @Override
        public final Builder changeDetectingColumns(Collection<String> changeDetectingColumns) {
            this.changeDetectingColumns = ChangeDetectingColumnsCopier.copy(changeDetectingColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeDetectingColumns(String ... changeDetectingColumns) {
            this.changeDetectingColumns(Arrays.asList(changeDetectingColumns));
            return this;
        }

        public ColumnConfiguration build() {
            return new ColumnConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnConfiguration> {
        public Builder documentIdColumnName(String var1);

        public Builder documentDataColumnName(String var1);

        public Builder documentTitleColumnName(String var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder changeDetectingColumns(Collection<String> var1);

        public Builder changeDetectingColumns(String ... var1);
    }
}

